/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util.modifier;

import com.google.common.collect.ImmutableList;
import io.github.edwinmindcraft.apoli.api.power.ModifierData;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredModifier;
import io.github.edwinmindcraft.apoli.api.power.factory.ModifierOperation;
import io.github.edwinmindcraft.apoli.common.registry.ApoliModifierOperations;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class ModifierUtil {
    public static ConfiguredModifier<?> createSimpleModifier(Supplier<ModifierOperation> operation, double value) {
        return new ConfiguredModifier<ModifierOperation>(operation, new ModifierData(value, Optional.empty(), (List<ConfiguredModifier<?>>)ImmutableList.of()));
    }

    public static ConfiguredModifier<?> fromAttributeModifier(AttributeModifier attributeModifier) {
        Supplier<ModifierOperation> operation = null;
        switch (attributeModifier.m_22217_()) {
            case ADDITION: {
                operation = () -> ApoliModifierOperations.ADD_BASE_EARLY.get();
                break;
            }
            case MULTIPLY_BASE: {
                operation = () -> ApoliModifierOperations.MULTIPLY_BASE_ADDITIVE.get();
                break;
            }
            case MULTIPLY_TOTAL: {
                operation = () -> ApoliModifierOperations.MULTIPLY_TOTAL_MULTIPLICATIVE.get();
            }
        }
        if (operation == null) {
            throw new RuntimeException("Could not construct generic modifier from attribute modifier. Unknown operation: " + attributeModifier.m_22217_());
        }
        return ModifierUtil.createSimpleModifier(operation, attributeModifier.m_22218_());
    }

    public static Map<ModifierOperation, List<ConfiguredModifier<?>>> sortModifiers(List<ConfiguredModifier<?>> modifiers) {
        HashMap buckets = new HashMap();
        for (ConfiguredModifier<?> modifier : modifiers) {
            List list = buckets.computeIfAbsent((ModifierOperation)modifier.getFactory(), (Function<ModifierOperation, List<ConfiguredModifier<?>>>)((Function<ModifierOperation, List>)op -> new LinkedList()));
            list.add(modifier);
        }
        return buckets;
    }

    public static double applyModifiers(Entity entity, List<ConfiguredModifier<?>> modifiers, double baseValue) {
        return ModifierUtil.applyModifiers(entity, ModifierUtil.sortModifiers(modifiers), baseValue);
    }

    public static double applyModifiers(Entity entity, Map<ModifierOperation, List<ConfiguredModifier<?>>> modifiers, double baseValue) {
        double currentBase = baseValue;
        double currentValue = baseValue;
        LinkedList<ModifierOperation> operations = new LinkedList<ModifierOperation>(modifiers.keySet());
        operations.sort((o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (o1.getPhase() == o2.getPhase()) {
                return o1.getOrder() - o2.getOrder();
            }
            return o1.getPhase().ordinal() - o2.getPhase().ordinal();
        });
        ModifierOperation.Phase lastPhase = ModifierOperation.Phase.BASE;
        for (ModifierOperation op : operations) {
            List<ConfiguredModifier<?>> data = modifiers.get(op);
            if (op.getPhase() != lastPhase) {
                currentBase = currentValue;
            }
            currentValue = op.apply(data, entity, currentBase, currentValue);
        }
        return currentValue;
    }
}

