/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;

public enum Shape {
    CUBE,
    CHEBYSHEV,
    STAR,
    MANHATTAN,
    SPHERE,
    EUCLIDEAN;


    @Deprecated
    public static Collection<BlockPos> getPositions(BlockPos center, Shape shape, int radius) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        Shape.forPositions(center, shape, radius, positions::add, () -> false);
        return positions;
    }

    public static void forPositions(BlockPos center, Shape shape, int radius, Consumer<BlockPos> consumer, BooleanSupplier stopping) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    if (shape == CUBE || shape == CHEBYSHEV || (shape == SPHERE || shape == EUCLIDEAN) && i * i + j * j + k * k <= radius * radius || Math.abs(i) + Math.abs(j) + Math.abs(k) <= radius) {
                        mutable.m_122178_(center.m_123341_() + i, center.m_123342_() + j, center.m_123343_() + k);
                        consumer.accept((BlockPos)mutable);
                    }
                    if (!stopping.getAsBoolean()) continue;
                    return;
                }
            }
        }
    }

    public static double getDistance(Shape shape, double xDistance, double yDistance, double zDistance) {
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case SPHERE, EUCLIDEAN -> Math.sqrt(xDistance * xDistance + yDistance * yDistance + zDistance * zDistance);
            case STAR, MANHATTAN -> xDistance + yDistance + zDistance;
            case CUBE, CHEBYSHEV -> Math.max(Math.max(xDistance, yDistance), zDistance);
        };
    }
}

