/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.common.registry.ApoliLootFunctions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class RemovePowerLootFunction
extends LootItemConditionalFunction {
    private final EquipmentSlot slot;
    private final ResourceLocation powerId;

    private RemovePowerLootFunction(LootItemCondition[] conditions, EquipmentSlot slot, ResourceLocation powerId) {
        super(conditions);
        this.slot = slot;
        this.powerId = powerId;
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ApoliLootFunctions.REMOVE_POWER_LOOT_FUNCTION.get();
    }

    @NotNull
    public ItemStack m_7372_(@NotNull ItemStack stack, @NotNull LootContext context) {
        StackPowerUtil.removePower(stack, this.slot, this.powerId);
        return stack;
    }

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder(EquipmentSlot slot, ResourceLocation powerId) {
        return LootItemConditionalFunction.m_80683_(conditions -> new RemovePowerLootFunction((LootItemCondition[])conditions, slot, powerId));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RemovePowerLootFunction> {
        public void serialize(@NotNull JsonObject jsonObject, @NotNull RemovePowerLootFunction addPowerLootFunction, @NotNull JsonSerializationContext jsonSerializationContext) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)addPowerLootFunction, jsonSerializationContext);
            jsonObject.addProperty("slot", addPowerLootFunction.slot.m_20751_());
            jsonObject.addProperty("power", addPowerLootFunction.powerId.toString());
        }

        @NotNull
        public RemovePowerLootFunction deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext jsonDeserializationContext, LootItemCondition @NotNull [] lootConditions) {
            EquipmentSlot slot = (EquipmentSlot)SerializableDataTypes.EQUIPMENT_SLOT.read(jsonObject.get("slot"));
            ResourceLocation powerId = (ResourceLocation)SerializableDataTypes.IDENTIFIER.read(jsonObject.get("power"));
            return new RemovePowerLootFunction(lootConditions, slot, powerId);
        }
    }
}

