/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.common.collect.Lists;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.RecipePower;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRecipeSerializers;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PowerRestrictedCraftingRecipe
extends CustomRecipe {
    public PowerRestrictedCraftingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        if (inventory instanceof TransientCraftingContainer) {
            TransientCraftingContainer craftingInventory = (TransientCraftingContainer)inventory;
            return this.getRecipes(craftingInventory).stream().anyMatch(r -> r.m_5818_((Container)craftingInventory, world));
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        Optional<Recipe> optional;
        TransientCraftingContainer craftingMenu;
        Player player;
        if (inv instanceof TransientCraftingContainer && (player = this.getPlayerFromInventory(craftingMenu = (TransientCraftingContainer)inv)) != null && (optional = this.getRecipes(craftingMenu).stream().filter(r -> r.m_5818_((Container)inv, player.m_9236_())).findFirst()).isPresent()) {
            Recipe recipe = optional.get();
            return recipe.m_5874_((Container)inv, access);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ApoliRecipeSerializers.POWER_RESTRICTED.get();
    }

    private Player getPlayerFromInventory(TransientCraftingContainer inv) {
        return this.getPlayerFromHandler(inv.f_286998_);
    }

    private List<Recipe<CraftingContainer>> getRecipes(TransientCraftingContainer inv) {
        Player player = this.getPlayerFromHandler(inv.f_286998_);
        if (player != null) {
            return IPowerContainer.getPowers((Entity)player, (RecipePower)ApoliPowers.RECIPE.get()).stream().map(x -> (Recipe)((FieldConfiguration)((ConfiguredPower)x.m_203334_()).getConfiguration()).value()).toList();
        }
        return Lists.newArrayList();
    }

    private Player getPlayerFromHandler(AbstractContainerMenu screenHandler) {
        if (screenHandler instanceof CraftingMenu) {
            CraftingMenu menu = (CraftingMenu)screenHandler;
            return menu.f_39351_;
        }
        if (screenHandler instanceof InventoryMenu) {
            InventoryMenu menu = (InventoryMenu)screenHandler;
            return menu.f_39703_;
        }
        return null;
    }
}

