/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.common.registry.ApoliLootConditions;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class PowerLootCondition
implements LootItemCondition {
    private final ResourceLocation powerId;
    private final ResourceLocation powerSourceId;

    private PowerLootCondition(ResourceLocation powerId) {
        this.powerId = powerId;
        this.powerSourceId = null;
    }

    private PowerLootCondition(ResourceLocation powerId, ResourceLocation powerSourceId) {
        this.powerId = powerId;
        this.powerSourceId = powerSourceId;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)ApoliLootConditions.POWER_LOOT_CONDITION.get();
    }

    public boolean test(LootContext lootContext) {
        Optional optionalPowerHolderComponent = IPowerContainer.get((Entity)lootContext.m_165124_(LootContextParams.f_81455_)).resolve();
        if (optionalPowerHolderComponent.isPresent()) {
            IPowerContainer powerHolderComponent = (IPowerContainer)optionalPowerHolderComponent.get();
            if (this.powerSourceId != null) {
                return powerHolderComponent.hasPower(this.powerId, this.powerSourceId);
            }
            return powerHolderComponent.hasPower(this.powerId);
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<PowerLootCondition> {
        public void serialize(JsonObject jsonObject, PowerLootCondition powerLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("power", powerLootCondition.powerId.toString());
            if (powerLootCondition.powerSourceId != null) {
                jsonObject.addProperty("source", powerLootCondition.powerSourceId.toString());
            }
        }

        public PowerLootCondition deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            ResourceLocation power = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"power"));
            if (jsonObject.has("source")) {
                ResourceLocation source = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"source"));
                return new PowerLootCondition(power, source);
            }
            return new PowerLootCondition(power);
        }
    }
}

