/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.common.collect.Lists;
import io.github.apace100.apoli.access.PowerCraftingInventory;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyCraftingPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyCraftingConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRecipeSerializers;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class ModifiedCraftingRecipe
extends CustomRecipe {
    public ModifiedCraftingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        TransientCraftingContainer craftingMenu;
        Player player;
        List<ConfiguredPower<ModifyCraftingConfiguration, ModifyCraftingPower>> recipes;
        if (inv instanceof TransientCraftingContainer && !(recipes = this.getRecipes(player = ModifiedCraftingRecipe.getCraftingPlayer(craftingMenu = (TransientCraftingContainer)inv))).isEmpty()) {
            Optional<CraftingRecipe> original = this.getOriginalMatch(inv, player, world.m_9598_());
            return original.isPresent() && recipes.stream().anyMatch(r -> ((ModifyCraftingConfiguration)r.getConfiguration()).doesApply(inv, (Recipe<? super CraftingContainer>)((Recipe)original.get()), world));
        }
        return false;
    }

    private static Player getCraftingPlayer(@NotNull TransientCraftingContainer inv) {
        Player player = ForgeHooks.getCraftingPlayer();
        if (player != null) {
            return player;
        }
        return ModifiedCraftingRecipe.getPlayerFromInventory(inv);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess access) {
        Optional<ConfiguredPower> optional;
        Optional<CraftingRecipe> original;
        TransientCraftingContainer craftingMenu;
        Player player;
        if (inv instanceof TransientCraftingContainer && (player = ModifiedCraftingRecipe.getCraftingPlayer(craftingMenu = (TransientCraftingContainer)inv)) != null && (original = this.getOriginalMatch(inv, player, access)).isPresent() && (optional = this.getRecipes(player).stream().filter(r -> ((ModifyCraftingConfiguration)r.getConfiguration()).doesApply(inv, (Recipe<? super CraftingContainer>)((Recipe)original.get()), player.m_9236_())).findFirst()).isPresent()) {
            ItemStack result = ((ModifyCraftingConfiguration)optional.get().getConfiguration()).createResult(inv, (Recipe<? super CraftingContainer>)((Recipe)original.get()), player.m_9236_());
            ((PowerCraftingInventory)inv).setPower(optional.get());
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ApoliRecipeSerializers.MODIFIED.get();
    }

    public static Player getPlayerFromInventory(TransientCraftingContainer inv) {
        AbstractContainerMenu handler = inv.f_286998_;
        return ModifiedCraftingRecipe.getPlayerFromHandler(handler);
    }

    public static Optional<BlockPos> getBlockFromInventory(TransientCraftingContainer inv) {
        AbstractContainerMenu handler = inv.f_286998_;
        if (handler instanceof CraftingMenu) {
            CraftingMenu menu = (CraftingMenu)handler;
            return menu.f_39350_.m_6721_((world, blockPos) -> blockPos);
        }
        return Optional.empty();
    }

    private List<ConfiguredPower<ModifyCraftingConfiguration, ModifyCraftingPower>> getRecipes(Player player) {
        if (player != null) {
            return IPowerContainer.getPowers((Entity)player, (ModifyCraftingPower)ApoliPowers.MODIFY_CRAFTING.get()).stream().map(Holder::m_203334_).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private Optional<CraftingRecipe> getOriginalMatch(CraftingContainer inv, Player player, RegistryAccess access) {
        if (player != null && player.m_20194_() != null) {
            Level level = player.m_9236_();
            return player.m_20194_().m_129894_().m_44054_(RecipeType.f_44107_).values().stream().filter(cr -> !(cr instanceof ModifiedCraftingRecipe) && cr.m_5818_((Container)inv, level)).min(Comparator.comparing(p_220247_ -> p_220247_.m_8043_(access).m_41778_()));
        }
        return Optional.empty();
    }

    private static Player getPlayerFromHandler(AbstractContainerMenu screenHandler) {
        if (screenHandler instanceof CraftingMenu) {
            CraftingMenu menu = (CraftingMenu)screenHandler;
            return menu.f_39351_;
        }
        if (screenHandler instanceof InventoryMenu) {
            InventoryMenu menu = (InventoryMenu)screenHandler;
            return menu.f_39703_;
        }
        return null;
    }
}

