/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.gson.JsonSyntaxException;
import io.github.apace100.apoli.data.DamageSourceDescription;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public final class MiscUtil {
    public static Optional<Entity> getEntityWithPassengers(Level world, EntityType<?> entityType, @Nullable CompoundTag entityNbt, Vec3 pos, float yaw, float pitch) {
        if (world.m_5776_()) {
            return Optional.empty();
        }
        ServerLevel serverWorld = (ServerLevel)world;
        CompoundTag entityToSpawnNbt = new CompoundTag();
        if (entityNbt != null) {
            entityToSpawnNbt.m_128391_(entityNbt);
        }
        entityToSpawnNbt.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(entityType).toString());
        Entity entityToSpawn = EntityType.m_20645_((CompoundTag)entityToSpawnNbt, (Level)serverWorld, entity -> {
            entity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, yaw, pitch);
            return entity;
        });
        if (entityToSpawn == null) {
            return Optional.empty();
        }
        if (entityNbt == null && entityToSpawn instanceof Mob) {
            Mob mobToSpawn = (Mob)entityToSpawn;
            ForgeEventFactory.onFinalizeSpawn((Mob)mobToSpawn, (ServerLevelAccessor)serverWorld, (DifficultyInstance)serverWorld.m_6436_(BlockPos.m_274446_((Position)pos)), (MobSpawnType)MobSpawnType.COMMAND, null, null);
        }
        return Optional.of(entityToSpawn);
    }

    public static BlockState getInWallBlockState(LivingEntity playerEntity) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d = playerEntity.m_20185_() + (double)(((float)(i % 2) - 0.5f) * playerEntity.m_20205_() * 0.8f);
            double e = playerEntity.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = playerEntity.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * playerEntity.m_20205_() * 0.8f);
            mutable.m_122169_(d, e, f);
            BlockState blockState = playerEntity.m_9236_().m_8055_((BlockPos)mutable);
            if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60831_((BlockGetter)playerEntity.m_9236_(), (BlockPos)mutable)) continue;
            return blockState;
        }
        return null;
    }

    public static DamageSource createDamageSource(DamageSources damageSources, Optional<DamageSourceDescription> damageSourceDescription, Optional<ResourceKey<DamageType>> damageType) {
        if (damageSourceDescription.isEmpty() && damageType.isEmpty()) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription.isEmpty() ? damageSources.m_269079_(damageType.get()) : damageSourceDescription.get().create(damageSources);
    }

    public static DamageSource createDamageSource(DamageSources damageSources, Optional<DamageSourceDescription> damageSourceDescription, Optional<ResourceKey<DamageType>> damageType, Entity attacker) {
        if (damageSourceDescription.isEmpty() && damageType.isEmpty()) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription.isEmpty() ? damageSources.m_269298_(damageType.get(), attacker) : damageSourceDescription.get().create(damageSources, attacker);
    }

    public static DamageSource createDamageSource(DamageSources damageSources, Optional<DamageSourceDescription> damageSourceDescription, Optional<ResourceKey<DamageType>> damageType, Entity source, Entity attacker) {
        if (damageSourceDescription.isEmpty() && damageType.isEmpty()) {
            throw new JsonSyntaxException("Either a legacy damage source or an ID of a damage type must be specified");
        }
        return damageSourceDescription.isEmpty() ? damageSources.m_268998_(damageType.get(), source, attacker) : damageSourceDescription.get().create(damageSources, source, attacker);
    }

    public static DamageSource createDamageSource(DamageSources damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable ResourceKey<DamageType> damageType) {
        return MiscUtil.createDamageSource(damageSources, Optional.ofNullable(damageSourceDescription), Optional.ofNullable(damageType));
    }

    public static DamageSource createDamageSource(DamageSources damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable ResourceKey<DamageType> damageType, Entity attacker) {
        return MiscUtil.createDamageSource(damageSources, Optional.ofNullable(damageSourceDescription), Optional.ofNullable(damageType), attacker);
    }

    public static DamageSource createDamageSource(DamageSources damageSources, @Nullable DamageSourceDescription damageSourceDescription, @Nullable ResourceKey<DamageType> damageType, Entity source, Entity attacker) {
        return MiscUtil.createDamageSource(damageSources, Optional.ofNullable(damageSourceDescription), Optional.ofNullable(damageType), source, attacker);
    }
}

