/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class JsonTextFormatter {
    private static final ChatFormatting NULL_COLOR = ChatFormatting.LIGHT_PURPLE;
    private static final ChatFormatting NAME_COLOR = ChatFormatting.AQUA;
    private static final ChatFormatting STRING_COLOR = ChatFormatting.GREEN;
    private static final ChatFormatting NUMBER_COLOR = ChatFormatting.GOLD;
    private static final ChatFormatting BOOLEAN_COLOR = ChatFormatting.BLUE;
    private static final ChatFormatting TYPE_SUFFIX_COLOR = ChatFormatting.RED;
    private final String indent;
    private final int indentOffset;
    private Component result;
    private boolean root;

    public JsonTextFormatter(String indent) {
        this(indent, 1);
    }

    protected JsonTextFormatter(String indent, int indentOffset) {
        this.indent = indent;
        this.indentOffset = Math.max(0, indentOffset);
        this.result = CommonComponents.f_237098_;
        this.root = true;
    }

    public Component apply(JsonElement jsonElement) {
        if (!this.handleJsonElement(jsonElement)) {
            throw new JsonParseException("The format of the specified JSON element is not supported!");
        }
        return this.result;
    }

    protected Component apply(JsonElement jsonElement, boolean rootElement) {
        this.root = rootElement;
        return this.apply(jsonElement);
    }

    protected final boolean handleJsonElement(JsonElement jsonElement) {
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            this.visitArray(jsonArray);
            return true;
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            this.visitObject(jsonObject);
            return true;
        }
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            this.visitPrimitive(jsonPrimitive);
            return true;
        }
        if (jsonElement instanceof JsonNull) {
            this.result = Component.m_237113_((String)"null").m_130940_(NULL_COLOR);
            return true;
        }
        return false;
    }

    public void visitArray(JsonArray jsonArray) {
        if (jsonArray.isEmpty()) {
            this.result = Component.m_237113_((String)"[]");
            return;
        }
        MutableComponent result = Component.m_237113_((String)"[");
        if (!this.indent.isEmpty()) {
            result.m_130946_("\n");
        }
        Iterator iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            JsonElement jsonElement = (JsonElement)iterator.next();
            result.m_130946_(Strings.repeat((String)this.indent, (int)this.indentOffset)).m_7220_(new JsonTextFormatter(this.indent, this.indentOffset + 1).apply(jsonElement, false));
            if (!iterator.hasNext()) continue;
            result.m_130946_(!this.indent.isEmpty() ? ",\n" : ", ");
        }
        if (!this.indent.isEmpty()) {
            result.m_130946_("\n");
        }
        if (!this.root) {
            result.m_130946_(Strings.repeat((String)this.indent, (int)(this.indentOffset - 1)));
        }
        result.m_130946_("]");
        this.result = result;
    }

    public void visitObject(JsonObject jsonObject) {
        if (jsonObject.keySet().isEmpty()) {
            this.result = Component.m_237113_((String)"{}");
            return;
        }
        MutableComponent result = Component.m_237113_((String)"{");
        if (!this.indent.isEmpty()) {
            result.m_130946_("\n");
        }
        Iterator iterator = jsonObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            MutableComponent name = Component.m_237113_((String)((String)entry.getKey())).m_130940_(NAME_COLOR);
            result.m_130946_(Strings.repeat((String)this.indent, (int)this.indentOffset)).m_7220_((Component)name).m_130946_(": ").m_7220_(new JsonTextFormatter(this.indent, this.indentOffset + 1).apply((JsonElement)entry.getValue(), false));
            if (!iterator.hasNext()) continue;
            result.m_130946_(!this.indent.isEmpty() ? ",\n" : ", ");
        }
        if (!this.indent.isEmpty()) {
            result.m_130946_("\n");
        }
        if (!this.root) {
            result.m_130946_(Strings.repeat((String)this.indent, (int)(this.indentOffset - 1)));
        }
        result.m_130946_("}");
        this.result = result;
    }

    public void visitPrimitive(JsonPrimitive jsonPrimitive) {
        if (!this.handlePrimitive(jsonPrimitive)) {
            throw new JsonParseException("Specified JSON primitive is not supported!");
        }
    }

    protected final boolean handlePrimitive(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isBoolean()) {
            this.result = Component.m_237113_((String)String.valueOf(jsonPrimitive.getAsBoolean())).m_130940_(BOOLEAN_COLOR);
            return true;
        }
        if (jsonPrimitive.isString()) {
            this.result = Component.m_237113_((String)("\"" + jsonPrimitive.getAsString() + "\"")).m_130940_(STRING_COLOR);
            return true;
        }
        if (jsonPrimitive.isNumber()) {
            MutableComponent numberText;
            Number number = jsonPrimitive.getAsNumber();
            if (number instanceof Integer) {
                Integer i = (Integer)number;
                numberText = Component.m_237113_((String)String.valueOf(i)).m_130940_(NUMBER_COLOR);
            } else if (number instanceof Long) {
                Long l = (Long)number;
                numberText = Component.m_237113_((String)String.valueOf(l)).m_130940_(NUMBER_COLOR).m_7220_((Component)Component.m_237113_((String)"L").m_130940_(TYPE_SUFFIX_COLOR));
            } else if (number instanceof Float) {
                Float f = (Float)number;
                numberText = Component.m_237113_((String)String.valueOf(f)).m_130940_(NUMBER_COLOR).m_7220_((Component)Component.m_237113_((String)"F").m_130940_(TYPE_SUFFIX_COLOR));
            } else if (number instanceof Double) {
                Double d = (Double)number;
                numberText = Component.m_237113_((String)String.valueOf(d)).m_130940_(NUMBER_COLOR).m_7220_((Component)Component.m_237113_((String)"D").m_130940_(TYPE_SUFFIX_COLOR));
            } else if (number instanceof Byte) {
                Byte b = (Byte)number;
                numberText = Component.m_237113_((String)String.valueOf(b)).m_130940_(NUMBER_COLOR).m_7220_((Component)Component.m_237113_((String)"B")).m_130940_(TYPE_SUFFIX_COLOR);
            } else if (number instanceof Short) {
                Short s = (Short)number;
                numberText = Component.m_237113_((String)String.valueOf(s)).m_130940_(NUMBER_COLOR).m_7220_((Component)Component.m_237113_((String)"S")).m_130940_(TYPE_SUFFIX_COLOR);
            } else {
                return false;
            }
            this.result = numberText;
            return true;
        }
        return false;
    }
}

