/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import io.github.apace100.apoli.mixin.ItemSlotArgumentTypeAccessor;
import io.github.apace100.calio.util.ArgumentWrapper;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.configuration.ListConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemAction;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.InventoryPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.InventoryConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.registry.condition.ApoliDefaultConditions;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class InventoryUtil {
    private static final SlotArgument SLOT_ARGUMENT = new SlotArgument();

    public static Set<Integer> getSlots(ListConfiguration<ArgumentWrapper<Integer>> slotArgumentTypes) {
        HashSet<Integer> slots = new HashSet<Integer>();
        if (slotArgumentTypes.entries().isEmpty()) {
            Map<String, Integer> slotNamesWithId = ((ItemSlotArgumentTypeAccessor)SLOT_ARGUMENT).getSlotNamesToSlotCommandId();
            slots.addAll(slotNamesWithId.values());
        } else {
            for (ArgumentWrapper<Integer> slotArgumentType : slotArgumentTypes.entries()) {
                slots.add((Integer)slotArgumentType.get());
            }
        }
        return slots;
    }

    public static int checkInventory(Holder<ConfiguredItemCondition<?, ?>> itemCondition, ListConfiguration<ArgumentWrapper<Integer>> slotArgumentTypes, Entity entity, ConfiguredPower<InventoryConfiguration, InventoryPower> inventoryPower, Function<ItemStack, Integer> processor) {
        Set<Integer> slots = InventoryUtil.getSlots(slotArgumentTypes);
        InventoryUtil.deduplicateSlots(entity, slots);
        int matches = 0;
        if (inventoryPower == null) {
            for (int slot : slots) {
                SlotAccess slotAccess = entity.m_141942_(slot);
                if (slotAccess == SlotAccess.f_147290_) continue;
                ItemStack stack = slotAccess.m_142196_();
                if ((!itemCondition.m_203633_() || !itemCondition.m_203373_(ApoliDefaultConditions.ITEM_DEFAULT.getId()) || stack.m_41619_()) && !ConfiguredItemCondition.check(itemCondition, entity.m_9236_(), stack)) continue;
                matches += processor.apply(stack).intValue();
            }
        } else {
            for (int slot : slots) {
                if (slot < 0 || slot >= inventoryPower.getFactory().getInventory(inventoryPower, entity).m_6643_()) continue;
                ItemStack stack = inventoryPower.getFactory().getInventory(inventoryPower, entity).m_8020_(slot);
                if ((!itemCondition.m_203633_() || !itemCondition.m_203373_(ApoliDefaultConditions.ITEM_DEFAULT.getId()) || stack.m_41619_()) && !ConfiguredItemCondition.check(itemCondition, entity.m_9236_(), stack)) continue;
                matches += processor.apply(stack).intValue();
            }
        }
        return matches;
    }

    public static void modifyInventory(ListConfiguration<ArgumentWrapper<Integer>> slotArgumentTypes, Holder<ConfiguredEntityAction<?, ?>> entityAction, Holder<ConfiguredItemCondition<?, ?>> itemCondition, Holder<ConfiguredItemAction<?, ?>> itemAction, Entity entity, Optional<ResourceLocation> powerId, Function<ItemStack, Integer> processor, int limit) {
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        Set<Integer> slots = InventoryUtil.getSlots(slotArgumentTypes);
        InventoryUtil.deduplicateSlots(entity, slots);
        int counter = 0;
        if (powerId.isEmpty()) {
            for (int slot2 : slots) {
                ItemStack currentItemStack;
                SlotAccess stackReference = entity.m_141942_(slot2);
                if (stackReference == SlotAccess.f_147290_ || (currentItemStack = stackReference.m_142196_()).m_41619_() || !ConfiguredItemCondition.check(itemCondition, entity.m_9236_(), currentItemStack)) continue;
                ConfiguredEntityAction.execute(entityAction, entity);
                int amount = processor.apply(currentItemStack);
                for (int i = 0; i < amount; ++i) {
                    MutableObject newStack = new MutableObject((Object)currentItemStack);
                    ConfiguredItemAction.execute(itemAction, entity.m_9236_(), (Mutable<ItemStack>)newStack);
                    stackReference.m_142104_((ItemStack)newStack.getValue());
                    if (++counter >= limit) break;
                }
                if (counter < limit) continue;
                break;
            }
        } else {
            ConfiguredPower power = IPowerContainer.get(entity).resolve().map(x -> x.getPower((ResourceLocation)powerId.get())).map(Holder::m_203334_).orElse(null);
            if (power == null || !(power.getFactory() instanceof InventoryPower)) {
                return;
            }
            ConfiguredPower inventoryPower = power;
            int inventorySize = ((InventoryPower)inventoryPower.getFactory()).getSize(inventoryPower, entity);
            slots.removeIf(slot -> slot > inventorySize);
            for (int i = 0; i < inventorySize; ++i) {
                Container container;
                ItemStack currentItemStack;
                if (!slots.isEmpty() && !slots.contains(i) || (currentItemStack = (container = ((InventoryPower)inventoryPower.getFactory()).getInventory(inventoryPower, entity)).m_8020_(i)).m_41619_() || !ConfiguredItemCondition.check(itemCondition, entity.m_9236_(), currentItemStack)) continue;
                ConfiguredEntityAction.execute(entityAction, entity);
                MutableObject newStack = new MutableObject((Object)currentItemStack);
                ConfiguredItemAction.execute(itemAction, entity.m_9236_(), (Mutable<ItemStack>)newStack);
                container.m_6836_(i, (ItemStack)newStack.getValue());
            }
        }
    }

    public static void replaceInventory(ListConfiguration<ArgumentWrapper<Integer>> slotArgumentTypes, ItemStack replacementStack, Holder<ConfiguredEntityAction<?, ?>> entityAction, Holder<ConfiguredItemCondition<?, ?>> itemCondition, Holder<ConfiguredItemAction<?, ?>> itemAction, Entity entity, Optional<ResourceLocation> powerId, boolean mergeNbt) {
        Set<Integer> slots = InventoryUtil.getSlots(slotArgumentTypes);
        InventoryUtil.deduplicateSlots(entity, slots);
        if (powerId.isEmpty()) {
            for (Integer slot2 : slots) {
                SlotAccess stackReference = entity.m_141942_(slot2.intValue());
                if (stackReference == SlotAccess.f_147290_) continue;
                ItemStack currentItemStack = stackReference.m_142196_();
                if (!ConfiguredItemCondition.check(itemCondition, entity.m_9236_(), currentItemStack)) continue;
                ConfiguredEntityAction.execute(entityAction, entity);
                MutableObject newStack = new MutableObject((Object)replacementStack.m_41777_());
                if (mergeNbt && ((ItemStack)newStack.getValue()).m_41782_()) {
                    ((ItemStack)newStack.getValue()).m_41784_().m_128391_(replacementStack.m_41784_());
                }
                ConfiguredItemAction.execute(itemAction, entity.m_9236_(), (Mutable<ItemStack>)newStack);
                stackReference.m_142104_((ItemStack)newStack.getValue());
            }
        } else {
            ConfiguredPower power = IPowerContainer.get(entity).resolve().map(x -> x.getPower((ResourceLocation)powerId.get())).map(Holder::m_203334_).orElse(null);
            if (power == null || !(power.getFactory() instanceof InventoryPower)) {
                return;
            }
            ConfiguredPower inventoryPower = power;
            int inventorySize = ((InventoryPower)inventoryPower.getFactory()).getSize(inventoryPower, entity);
            slots.removeIf(slot -> slot > inventorySize);
            for (int i = 0; i < inventorySize; ++i) {
                if (!slots.isEmpty() && !slots.contains(i)) continue;
                Container container = ((InventoryPower)inventoryPower.getFactory()).getInventory(inventoryPower, entity);
                ItemStack currentItemStack = container.m_8020_(i);
                if (!ConfiguredItemCondition.check(itemCondition, entity.m_9236_(), currentItemStack)) continue;
                ConfiguredEntityAction.execute(entityAction, entity);
                MutableObject newStack = new MutableObject((Object)replacementStack.m_41777_());
                if (mergeNbt && ((ItemStack)newStack.getValue()).m_41782_()) {
                    ((ItemStack)newStack.getValue()).m_41784_().m_128391_(replacementStack.m_41784_());
                }
                ConfiguredItemAction.execute(itemAction, entity.m_9236_(), (Mutable<ItemStack>)newStack);
                container.m_6836_(i, (ItemStack)newStack.getValue());
            }
        }
    }

    public static void dropInventory(ListConfiguration<ArgumentWrapper<Integer>> slotArgumentTypes, Holder<ConfiguredEntityAction<?, ?>> entityAction, Holder<ConfiguredItemCondition<?, ?>> itemCondition, Holder<ConfiguredItemAction<?, ?>> itemAction, boolean throwRandomly, boolean retainOwnership, Entity entity, Optional<ResourceLocation> powerId, int amount) {
        Set<Integer> slots = InventoryUtil.getSlots(slotArgumentTypes);
        InventoryUtil.deduplicateSlots(entity, slots);
        if (powerId.isEmpty()) {
            for (Integer slot2 : slots) {
                ItemStack currentItemStack;
                SlotAccess stackReference = entity.m_141942_(slot2.intValue());
                if (stackReference == SlotAccess.f_147290_ || (currentItemStack = stackReference.m_142196_()).m_41619_() || !ConfiguredItemCondition.check(itemCondition, entity.m_9236_(), currentItemStack)) continue;
                ConfiguredEntityAction.execute(entityAction, entity);
                MutableObject newStack = new MutableObject((Object)currentItemStack.m_41777_());
                ConfiguredItemAction.execute(itemAction, entity.m_9236_(), (Mutable<ItemStack>)newStack);
                if (amount != 0) {
                    int newAmount = amount > 0 ? amount * -1 : amount;
                    newStack.setValue((Object)((ItemStack)newStack.getValue()).m_41620_(newAmount));
                    stackReference.m_142104_((ItemStack)newStack.getValue());
                } else {
                    stackReference.m_142104_(ItemStack.f_41583_);
                }
                InventoryUtil.throwItem(entity, (ItemStack)newStack.getValue(), throwRandomly, retainOwnership);
            }
        } else {
            ConfiguredPower power = IPowerContainer.get(entity).resolve().map(x -> x.getPower((ResourceLocation)powerId.get())).map(Holder::m_203334_).orElse(null);
            if (power == null || !(power.getFactory() instanceof InventoryPower)) {
                return;
            }
            ConfiguredPower inventoryPower = power;
            int containerSize = ((InventoryPower)inventoryPower.getFactory()).getSize(inventoryPower, entity);
            slots.removeIf(slot -> slot > containerSize);
            for (int i = 0; i < containerSize; ++i) {
                Container container;
                ItemStack currentItemStack;
                if (!slots.isEmpty() && !slots.contains(i) || (currentItemStack = (container = ((InventoryPower)inventoryPower.getFactory()).getInventory(inventoryPower, entity)).m_8020_(i)).m_41619_() || !ConfiguredItemCondition.check(itemCondition, entity.m_9236_(), currentItemStack)) continue;
                ConfiguredEntityAction.execute(entityAction, entity);
                MutableObject newStack = new MutableObject((Object)currentItemStack.m_41777_());
                ConfiguredItemAction.execute(itemAction, entity.m_9236_(), (Mutable<ItemStack>)newStack);
                if (amount != 0) {
                    int newAmount = amount > 0 ? amount * -1 : amount;
                    newStack.setValue((Object)((ItemStack)newStack.getValue()).m_41620_(newAmount));
                    container.m_6836_(i, (ItemStack)newStack.getValue());
                } else {
                    container.m_6836_(i, ItemStack.f_41583_);
                }
                InventoryUtil.throwItem(entity, (ItemStack)newStack.getValue(), throwRandomly, retainOwnership);
            }
        }
    }

    public static void throwItem(Entity thrower, ItemStack itemStack, boolean throwRandomly, boolean retainOwnership) {
        if (itemStack.m_41619_()) {
            return;
        }
        if (thrower instanceof Player) {
            Player playerEntity = (Player)thrower;
            if (playerEntity.m_9236_().f_46443_) {
                playerEntity.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
        double yOffset = thrower.m_20188_() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(thrower.m_9236_(), thrower.m_20185_(), yOffset, thrower.m_20189_(), itemStack);
        itemEntity.m_32010_(40);
        Random random = new Random();
        if (retainOwnership) {
            itemEntity.m_32052_(thrower.m_20148_());
        }
        if (throwRandomly) {
            float f = random.nextFloat() * 0.5f;
            float g = random.nextFloat() * ((float)Math.PI * 2);
            itemEntity.m_20334_((double)(-Mth.m_14031_((float)g) * f), (double)0.2f, (double)(Mth.m_14089_((float)g) * f));
        } else {
            float f = 0.3f;
            float g = Mth.m_14031_((float)(thrower.m_146909_() * ((float)Math.PI / 180)));
            float h = Mth.m_14089_((float)(thrower.m_146909_() * ((float)Math.PI / 180)));
            float i = Mth.m_14031_((float)(thrower.m_146908_() * ((float)Math.PI / 180)));
            float j = Mth.m_14089_((float)(thrower.m_146908_() * ((float)Math.PI / 180)));
            float k = random.nextFloat() * ((float)Math.PI * 2);
            float l = 0.02f * random.nextFloat();
            itemEntity.m_20334_((double)(-i * h * f) + Math.cos(k) * (double)l, (double)(-g * f + 0.1f + (random.nextFloat() - random.nextFloat()) * 0.1f), (double)(j * h * f) + Math.sin(k) * (double)l);
        }
        thrower.m_9236_().m_7967_((Entity)itemEntity);
    }

    @Deprecated
    public static void forEachStack(Entity entity, BiConsumer<Mutable<ItemStack>, SlotAccess> itemStackConsumer) {
        InventoryUtil.forEachStack(entity, (SlotAccess slotAccess) -> itemStackConsumer.accept((Mutable<ItemStack>)null, (SlotAccess)slotAccess));
    }

    public static void forEachStack(Entity entity, Consumer<SlotAccess> itemStackConsumer) {
        int skip = InventoryUtil.getDuplicatedSlotIndex(entity);
        for (int slot : ((ItemSlotArgumentTypeAccessor)SLOT_ARGUMENT).getSlotNamesToSlotCommandId().values()) {
            ItemStack stack;
            if (slot == skip) {
                skip = Integer.MIN_VALUE;
                continue;
            }
            SlotAccess stackReference = entity.m_141942_(slot);
            if (stackReference == SlotAccess.f_147290_ || (stack = stackReference.m_142196_()).m_41619_()) continue;
            itemStackConsumer.accept(stackReference);
        }
        Optional optionalPowerContainer = IPowerContainer.get(entity).resolve();
        if (optionalPowerContainer.isPresent()) {
            IPowerContainer phc = (IPowerContainer)optionalPowerContainer.get();
            List<ConfiguredPower> inventoryPowers = phc.getPowers((InventoryPower)ApoliPowers.INVENTORY.get()).stream().filter(Holder::m_203633_).map(Holder::m_203334_).toList();
            for (ConfiguredPower inventoryPower : inventoryPowers) {
                int inventorySize = ((InventoryPower)inventoryPower.getFactory()).getSize(inventoryPower, entity);
                for (int index = 0; index < inventorySize; ++index) {
                    ItemStack stack = ((InventoryPower)inventoryPower.getFactory()).getInventory(inventoryPower, entity).m_8020_(index);
                    if (stack.m_41619_()) continue;
                    itemStackConsumer.accept(SlotAccess.m_147292_((Container)((InventoryPower)inventoryPower.getFactory()).getInventory(inventoryPower, entity), (int)index));
                }
            }
        }
    }

    private static void deduplicateSlots(Entity entity, Set<Integer> slots) {
        int hotbarSlot = InventoryUtil.getDuplicatedSlotIndex(entity);
        if (hotbarSlot != Integer.MIN_VALUE && slots.contains(hotbarSlot)) {
            Integer mainHandSlot = ((ItemSlotArgumentTypeAccessor)SLOT_ARGUMENT).getSlotNamesToSlotCommandId().get("weapon.mainhand");
            slots.remove(mainHandSlot);
        }
    }

    private static int getDuplicatedSlotIndex(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int selectedSlot = player.m_150109_().f_35977_;
            return ((ItemSlotArgumentTypeAccessor)SLOT_ARGUMENT).getSlotNamesToSlotCommandId().get("hotbar." + selectedSlot);
        }
        return Integer.MIN_VALUE;
    }

    public static enum ProcessMode {
        STACKS(stack -> 1),
        ITEMS(ItemStack::m_41613_);

        private final Function<ItemStack, Integer> processor;

        private ProcessMode(Function<ItemStack, Integer> processor) {
            this.processor = processor;
        }

        public Function<ItemStack, Integer> getProcessor() {
            return this.processor;
        }
    }

    public static enum InventoryType {
        INVENTORY,
        POWER;

    }
}

