/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record HudRender(boolean shouldRender, int barIndex, ResourceLocation spriteLocation, Holder<ConfiguredEntityCondition<?, ?>> condition, boolean inverted) implements IDynamicFeatureConfiguration
{
    private static final ResourceLocation DEFAULT_SPRITE = new ResourceLocation("origins", "textures/gui/resource_bar.png");
    public static final MapCodec<HudRender> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"should_render", (Object)true).forGetter(HudRender::shouldRender), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.INT, (String)"bar_index", (Object)0).forGetter(HudRender::barIndex), (App)CalioCodecHelper.optionalField((Codec)ResourceLocation.f_135803_, (String)"sprite_location", (Object)DEFAULT_SPRITE).forGetter(HudRender::spriteLocation), (App)ConfiguredEntityCondition.optional("condition").forGetter(HudRender::condition), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"inverted", (Object)false).forGetter(HudRender::inverted)).apply((Applicative)instance, HudRender::new));
    public static final Codec<HudRender> CODEC = MAP_CODEC.codec();
    public static final HudRender DONT_RENDER = new HudRender(false, 0, DEFAULT_SPRITE, null, false);

    public ResourceLocation getSpriteLocation() {
        return this.spriteLocation();
    }

    public int getBarIndex() {
        return this.barIndex();
    }

    public boolean isInverted() {
        return this.inverted();
    }

    public boolean shouldRender(Entity entity) {
        return this.shouldRender() && ConfiguredEntityCondition.check(this.condition(), entity);
    }

    public boolean shouldRender(Player player) {
        return this.shouldRender((Entity)player);
    }

    public Holder<ConfiguredEntityCondition<?, ?>> getCondition() {
        return this.condition();
    }
}

