/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.screen;

import io.github.apace100.apoli.screen.GameHudRender;
import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.apace100.apoli.util.HudRender;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class PowerHudRenderer
implements GameHudRender {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics context, float delta) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        IPowerContainer.get((Entity)player).ifPresent(component -> {
            int x = client.m_91268_().m_85445_() / 2 + 20 + (Integer)ApoliConfigs.CLIENT.resourcesAndCooldowns.hudOffsetX.get();
            int y = client.m_91268_().m_85446_() - 47 + (Integer)ApoliConfigs.CLIENT.resourcesAndCooldowns.hudOffsetY.get();
            Entity patt1361$temp = player.m_20202_();
            if (patt1361$temp instanceof LivingEntity) {
                LivingEntity vehicle = (LivingEntity)patt1361$temp;
                y -= 8 * (int)(vehicle.m_21233_() / 20.0f);
            }
            if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) || player.m_20146_() < player.m_6062_()) {
                y -= 8;
            }
            int barWidth = 71;
            int barHeight = 8;
            int iconSize = 8;
            List<ConfiguredPower> configuredPowers = component.getPowers().stream().map(Holder::m_203334_).filter(power -> power.asHudRendered().isPresent()).sorted(Comparator.comparing(power -> power.getRenderSettings((Entity)player).orElse(HudRender.DONT_RENDER).spriteLocation())).toList();
            for (ConfiguredPower hudPower : configuredPowers) {
                HudRender render = hudPower.getRenderSettings((Entity)player).orElse(HudRender.DONT_RENDER);
                if (!render.shouldRender((Player)player) || !hudPower.shouldRender((Entity)player).orElse(false).booleanValue()) continue;
                ResourceLocation currentLocation = render.spriteLocation();
                context.m_280218_(currentLocation, x, y, 0, 0, barWidth, 5);
                int v = 8 + render.barIndex() * 10;
                float fill = hudPower.getFill((Entity)player).orElse(Float.valueOf(0.0f)).floatValue();
                if (render.isInverted()) {
                    fill = 1.0f - fill;
                }
                int w = (int)(fill * (float)barWidth);
                context.m_280218_(currentLocation, x, y - 2, 0, v, w, barHeight);
                context.m_280218_(currentLocation, x - iconSize - 2, y - 2, 73, v, iconSize, iconSize);
                y -= 8;
            }
        });
    }
}

