/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition.bientity;

import io.github.apace100.apoli.condition.configuration.RelativeRotationConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.BiEntityCondition;
import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RelativeRotationCondition
extends BiEntityCondition<RelativeRotationConfiguration> {
    public RelativeRotationCondition() {
        super(RelativeRotationConfiguration.CODEC);
    }

    @Override
    protected boolean check(@NotNull RelativeRotationConfiguration configuration, @NotNull Entity actor, @NotNull Entity target) {
        Vec3 vec0 = configuration.actorRotation().getRotation(actor);
        Vec3 vec1 = configuration.targetRotation().getRotation(target);
        EnumSet<Direction.Axis> axes = configuration.axes();
        vec0 = RelativeRotationCondition.reduceAxes(vec0, axes);
        vec1 = RelativeRotationCondition.reduceAxes(vec1, axes);
        double angle = RelativeRotationCondition.getAngleBetween(vec0, vec1);
        return configuration.comparison().check(angle);
    }

    private static double getAngleBetween(Vec3 a, Vec3 b) {
        double dot = a.m_82526_(b);
        return dot / (a.m_82553_() * b.m_82553_());
    }

    private static Vec3 reduceAxes(Vec3 vector, EnumSet<Direction.Axis> axesToKeep) {
        return new Vec3(axesToKeep.contains(Direction.Axis.X) ? vector.m_7096_() : 0.0, axesToKeep.contains(Direction.Axis.Y) ? vector.m_7098_() : 0.0, axesToKeep.contains(Direction.Axis.Z) ? vector.m_7094_() : 0.0);
    }

    private static Vec3 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = Mth.m_14089_((float)g);
        float i = Mth.m_14031_((float)g);
        float j = Mth.m_14089_((float)f);
        float k = Mth.m_14031_((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    public static enum RotationType {
        HEAD(e -> e.m_20252_(1.0f)),
        BODY(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)e;
                return RelativeRotationCondition.getRotationVector(0.0f, l.f_20883_);
            }
            return e.m_20252_(1.0f);
        });

        private final Function<Entity, Vec3> function;

        private RotationType(Function<Entity, Vec3> function) {
            this.function = function;
        }

        public Vec3 getRotation(Entity entity) {
            return this.function.apply(entity);
        }
    }
}

