/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import com.mojang.serialization.Codec;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.util.Comparison;
import io.github.edwinmindcraft.apoli.common.action.configuration.DistanceFromPointConfiguration;
import io.github.edwinmindcraft.apoli.common.action.configuration.ReferencePoint;
import io.github.edwinmindcraft.apoli.common.action.entity.DistanceFromPointEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.block.DistanceFromPointBlockCondition;
import io.github.edwinmindcraft.apoli.common.registry.ApoliRegisters;
import java.util.ArrayList;

public class DistanceFromCoordinatesConditionRegistry {
    private static final ArrayList<Object> previousWarnings = new ArrayList();

    private static void warnOnce(String warning, Object key) {
        if (!previousWarnings.contains(key)) {
            previousWarnings.add(key);
            Apoli.LOGGER.warn(warning);
        }
    }

    public static void warnOnce(String warning) {
        DistanceFromCoordinatesConditionRegistry.warnOnce(warning, warning);
    }

    public static <T> T warnCouldNotGetObject(String object, String from, T assumption) {
        DistanceFromCoordinatesConditionRegistry.warnOnce("Could not retrieve " + object + " from " + from + " for distance_from_spawn condition, assuming " + assumption + " for condition.");
        return assumption;
    }

    private static String[] getAliases() {
        return new String[]{"distance_from_spawn", "distance_from_coordinates"};
    }

    private static Codec<DistanceFromPointConfiguration> getSerializableData(String alias) {
        return DistanceFromPointConfiguration.codec(alias.equals("distance_from_coordinates") ? ReferencePoint.WORLD_ORIGIN : ReferencePoint.WORLD_SPAWN);
    }

    private static boolean compareOutOfBounds(Comparison comparison) {
        return comparison == Comparison.NOT_EQUAL || comparison == Comparison.GREATER_THAN || comparison == Comparison.GREATER_THAN_OR_EQUAL;
    }

    public static void registerBlockConditions() {
        for (String alias : DistanceFromCoordinatesConditionRegistry.getAliases()) {
            ApoliRegisters.BLOCK_CONDITIONS.register(alias, () -> new DistanceFromPointBlockCondition(DistanceFromCoordinatesConditionRegistry.getSerializableData(alias)));
        }
    }

    public static void registerEntityCondition() {
        for (String alias : DistanceFromCoordinatesConditionRegistry.getAliases()) {
            ApoliRegisters.ENTITY_CONDITIONS.register(alias, () -> new DistanceFromPointEntityCondition(DistanceFromCoordinatesConditionRegistry.getSerializableData(alias)));
        }
    }
}

