/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface Prioritized<C extends IDynamicFeatureConfiguration, T extends PowerFactory<C>> {
    public int getPriority(C var1);

    public static class CallInstance<C extends IDynamicFeatureConfiguration, T extends PowerFactory<C>> {
        private final HashMap<Integer, List<Holder<ConfiguredPower<C, T>>>> buckets = new HashMap();
        private int minPriority = Integer.MAX_VALUE;
        private int maxPriority = Integer.MIN_VALUE;

        public <U extends Holder<ConfiguredPower<C, T>>> void add(LivingEntity entity, T factory) {
            this.add((Entity)entity, factory, null);
        }

        public <U extends Holder<ConfiguredPower<C, T>>> void add(Entity entity, T factory, Predicate<U> filter) {
            Stream<Object> stream = ApoliAPI.getPowerContainer(entity).getPowers(factory).stream();
            if (filter != null) {
                stream = stream.filter(u -> u.m_203633_() && filter.test(u));
            }
            stream.forEach(this::add);
        }

        public int getMinPriority() {
            return this.minPriority;
        }

        public int getMaxPriority() {
            return this.maxPriority;
        }

        public boolean hasPowers(int priority) {
            return this.buckets.containsKey(priority);
        }

        public List<Holder<ConfiguredPower<C, T>>> getPowers(int priority) {
            if (this.buckets.containsKey(priority)) {
                return this.buckets.get(priority);
            }
            return new LinkedList<Holder<ConfiguredPower<C, T>>>();
        }

        public void add(Holder<ConfiguredPower<C, T>> power) {
            if (!power.m_203633_()) {
                return;
            }
            int priority = ((Prioritized)((ConfiguredPower)power.m_203334_()).getFactory()).getPriority(((ConfiguredPower)power.m_203334_()).getConfiguration());
            if (this.buckets.containsKey(priority)) {
                this.buckets.get(priority).add(power);
            } else {
                LinkedList<Holder<ConfiguredPower<C, T>>> list = new LinkedList<Holder<ConfiguredPower<C, T>>>();
                list.add(power);
                this.buckets.put(priority, list);
            }
            if (priority < this.minPriority) {
                this.minPriority = priority;
            }
            if (priority > this.maxPriority) {
                this.maxPriority = priority;
            }
        }
    }
}

