/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.mojang.datafixers.util.Pair;
import io.github.apace100.apoli.util.ModifiedCraftingRecipe;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin {
    @Shadow
    protected abstract <C extends Container, T extends Recipe<C>> Map<ResourceLocation, T> m_44054_(RecipeType<T> var1);

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private <C extends Container, T extends Recipe<C>> void prioritizeModifiedRecipes(RecipeType<T> type, C inventory, Level world, CallbackInfoReturnable<Optional<T>> cir) {
        Optional<Recipe> modifiedRecipe = this.m_44054_(type).values().stream().filter(recipe -> recipe.m_5818_(inventory, world)).filter(r -> r.getClass() == ModifiedCraftingRecipe.class).findFirst();
        if (modifiedRecipe.isPresent()) {
            cir.setReturnValue(modifiedRecipe);
        }
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private <C extends Container, T extends Recipe<C>> void prioritizeModifiedRecipes(RecipeType<T> type, C inventory, Level world, ResourceLocation location, CallbackInfoReturnable<Optional<Pair<ResourceLocation, T>>> cir) {
        Optional<Pair> modifiedRecipe;
        if (location == null && (modifiedRecipe = this.m_44054_(type).entrySet().stream().filter(recipe -> ((Recipe)recipe.getValue()).m_5818_(inventory, world)).filter(r -> ((Recipe)r.getValue()).getClass() == ModifiedCraftingRecipe.class).findFirst().map(kvp -> Pair.of((Object)((ResourceLocation)kvp.getKey()), (Object)((Recipe)kvp.getValue())))).isPresent()) {
            cir.setReturnValue(modifiedRecipe);
        }
    }
}

