/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.ModifyFoodPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValuePower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFoodConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.util.CoreUtils;
import io.github.edwinmindcraft.apoli.common.util.LivingDamageCache;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements Nameable,
CommandSource {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract boolean m_6469_(@NotNull DamageSource var1, float var2);

    @Shadow
    @NotNull
    public abstract ItemStack m_6844_(@NotNull EquipmentSlot var1);

    @Shadow
    @NotNull
    public abstract EntityDimensions m_6972_(@NotNull Pose var1);

    @Shadow
    @Nullable
    public abstract ItemEntity m_7197_(ItemStack var1, boolean var2, boolean var3);

    @Shadow
    public abstract Inventory m_150109_();

    @Inject(method={"updateSwimming"}, at={@At(value="TAIL")})
    private void updateSwimmingPower(CallbackInfo ci) {
        LazyOptional<IPowerContainer> lazyContainer = IPowerContainer.get((Entity)this);
        if (!lazyContainer.isPresent()) {
            return;
        }
        IPowerContainer container = (IPowerContainer)lazyContainer.orElseThrow(RuntimeException::new);
        if (container.hasPower((PowerFactory)ApoliPowers.SWIMMING.get())) {
            this.m_20282_(this.m_20142_() && !this.m_20159_());
            this.f_19798_ = this.m_6069_();
            if (this.m_6069_()) {
                this.f_19789_ = 0.0f;
                Vec3 look = this.m_20154_();
                this.m_6478_(MoverType.SELF, new Vec3(look.f_82479_ / 4.0, look.f_82480_ / 4.0, look.f_82481_ / 4.0));
            }
        } else if (container.hasPower((PowerFactory)ApoliPowers.IGNORE_WATER.get())) {
            this.m_20282_(false);
        }
    }

    @Inject(method={"getFlyingSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyFlySpeed(CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(IPowerContainer.modify((Entity)this, (ModifyValuePower)ApoliPowers.MODIFY_AIR_SPEED.get(), ((Float)cir.getReturnValue()).floatValue())));
    }

    @ModifyVariable(method={"eat"}, at=@At(value="HEAD"), argsOnly=true)
    private ItemStack modifyEatenItemStack(ItemStack original) {
        List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> mfps = ModifyFoodPower.getValidPowers((Entity)this, original);
        MutableObject stack = new MutableObject((Object)original.m_41777_());
        ModifyFoodPower.modifyStack(mfps, this.m_9236_(), (Mutable<ItemStack>)stack);
        ((ModifiableFoodEntity)((Object)this)).setCurrentModifyFoodPowers(mfps);
        ((ModifiableFoodEntity)((Object)this)).setOriginalFoodStack(original);
        return (ItemStack)stack.getValue();
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"causeFoodExhaustion"}, ordinal=0, name={"exhaustion"}, argsOnly=true)
    private float modifyExhaustion(float exhaustionIn) {
        return IPowerContainer.modify((Entity)this, (ModifyValuePower)ApoliPowers.MODIFY_EXHAUSTION.get(), exhaustionIn);
    }

    @Inject(method={"canTakeItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventArmorDispensing(ItemStack stack, CallbackInfoReturnable<Boolean> info) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        if (CoreUtils.isItemForbidden((Entity)this, slot, stack)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")}, cancellable=true)
    private void performDamageBypass(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        if (((LivingDamageCache)((Object)this)).bypassesDamageCheck() && pAmount == 0.0f) {
            cir.setReturnValue((Object)super.m_6469_(pSource, pAmount));
        }
    }
}

