/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.ReplacingLootContext;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.ReplaceLootTablePower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ReplaceLootTableConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LootTable.class})
public abstract class LootTableMixin {
    @Shadow
    private ResourceLocation lootTableId;

    @Shadow
    @Deprecated
    public abstract void m_79131_(LootContext var1, Consumer<ItemStack> var2);

    @Inject(method={"getRandomItems(Lnet/minecraft/world/level/storage/loot/LootContext;)Lit/unimi/dsi/fastutil/objects/ObjectArrayList;"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyLootTable(LootContext context, CallbackInfoReturnable<ObjectArrayList<ItemStack>> cir) {
        if (((ReplacingLootContext)context).isReplaced((LootTable)this) || this.lootTableId == null) {
            return;
        }
        if (context.m_78936_(LootContextParams.f_81455_)) {
            Piglin piglin;
            Optional optional;
            LootContextParamSet type = ((ReplacingLootContext)context).getType();
            Entity entity = (Entity)context.m_165124_(LootContextParams.f_81455_);
            if (type == LootContextParamSets.f_81414_) {
                if (entity instanceof FishingHook) {
                    FishingHook bobber = (FishingHook)entity;
                    entity = bobber.m_37168_();
                }
            } else if (type == LootContextParamSets.f_81415_) {
                if (context.m_78936_(LootContextParams.f_81458_)) {
                    entity = (Entity)context.m_165124_(LootContextParams.f_81458_);
                }
            } else if (type == LootContextParamSets.f_81417_ && entity instanceof Piglin && (optional = (piglin = (Piglin)entity).m_6274_().m_21952_(MemoryModuleType.f_26368_)).isPresent()) {
                entity = (Entity)optional.get();
            }
            List<ReplaceLootTableConfiguration> powers = IPowerContainer.getPowers(entity, (ReplaceLootTablePower)ApoliPowers.REPLACE_LOOT_TABLE.get()).stream().map(holder -> (ReplaceLootTableConfiguration)((ConfiguredPower)holder.m_203334_()).getConfiguration()).toList();
            Entity finalEntity = entity;
            if (finalEntity == null) {
                return;
            }
            if ((powers = powers.stream().filter(p -> p.hasReplacement(this.lootTableId) && p.doesApply(context, finalEntity)).sorted(Comparator.comparing(ReplaceLootTableConfiguration::priority)).toList()).isEmpty()) {
                return;
            }
            ReplaceLootTablePower.addToStack((LootTable)this);
            LootTable replacement = null;
            for (ReplaceLootTableConfiguration power : powers) {
                ResourceLocation id = power.getReplacement(this.lootTableId);
                replacement = ServerLifecycleHooks.getCurrentServer().m_278653_().m_278676_(id);
                ReplaceLootTablePower.addToStack(replacement);
            }
            ((ReplacingLootContext)context).setReplaced((LootTable)this);
            cir.setReturnValue((Object)replacement.m_230922_(context));
            ReplaceLootTablePower.clearStack();
        }
    }

    @Inject(method={"getRandomItemsRaw(Lnet/minecraft/world/level/storage/loot/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setReplacedLootTable(LootContext context, Consumer<ItemStack> lootConsumer, CallbackInfo ci) {
        if (this.lootTableId != null && this.lootTableId.equals((Object)ReplaceLootTablePower.REPLACED_TABLE_UTIL_ID)) {
            LootTable replace = ReplaceLootTablePower.peek();
            replace.m_79131_(context, lootConsumer);
            ci.cancel();
        }
    }

    @Inject(method={"getRandomItemsRaw(Lnet/minecraft/world/level/storage/loot/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootContext;pushVisitedElement(Lnet/minecraft/world/level/storage/loot/LootContext$VisitedEntry;)Z")})
    private void popReplacementStack(LootContext context, Consumer<ItemStack> lootConsumer, CallbackInfo ci) {
        ReplaceLootTablePower.pop();
    }

    @Inject(method={"getRandomItemsRaw(Lnet/minecraft/world/level/storage/loot/LootContext;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootContext;popVisitedElement(Lnet/minecraft/world/level/storage/loot/LootContext$VisitedEntry;)V")})
    private void restoreReplacementStack(LootContext context, Consumer<ItemStack> lootConsumer, CallbackInfo ci) {
        ReplaceLootTablePower.restore();
    }
}

