/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.EntityAttributeInstanceAccess;
import io.github.apace100.apoli.access.HiddenEffectStatus;
import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.apace100.apoli.util.StackPowerUtil;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.VariableAccess;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.configuration.TagConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.ApoliCommon;
import io.github.edwinmindcraft.apoli.common.network.S2CPlayerDismount;
import io.github.edwinmindcraft.apoli.common.network.S2CSyncAttacker;
import io.github.edwinmindcraft.apoli.common.power.ActionOnItemUsePower;
import io.github.edwinmindcraft.apoli.common.power.BiEntityConditionPower;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.EntityGroupPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyAttributePower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageDealtPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyDamageTakenPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyFoodPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyStatusEffectPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValuePower;
import io.github.edwinmindcraft.apoli.common.power.WalkOnFluidPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ActionOnItemUseConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyAttributeConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyDamageDealtConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyDamageTakenConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyFoodConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import io.github.edwinmindcraft.apoli.common.util.LivingDamageCache;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ModifiableFoodEntity,
LivingDamageCache {
    private List<Holder<ConfiguredPower<ModifyDamageTakenConfiguration, ModifyDamageTakenPower>>> apoli$damageMods;
    private List<Holder<ConfiguredPower<ModifyDamageDealtConfiguration, ModifyDamageDealtPower>>> apoli$damageSourceMods;
    private boolean apoli$bypassDamageCheck = false;
    private int apoli$shouldApplyArmor;
    private int apoli$shouldDamageArmor;
    @Unique
    private boolean prevPowderSnowState = false;
    @Shadow
    protected ItemStack f_20935_;
    @Unique
    private List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> apoli$currentModifyFoodPowers = new LinkedList<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>>();
    @Unique
    private ItemStack apoli$originalFoodStack;
    @Unique
    private boolean apoli$shouldSyncFoodData = false;

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @ModifyVariable(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private MobEffectInstance modifyStatusEffect(MobEffectInstance effect) {
        MobEffect effectType = effect.m_19544_();
        int originalAmp = effect.m_19564_();
        int originalDur = effect.m_19557_();
        int amplifier = Math.round(IPowerContainer.modify(this, (ModifyStatusEffectPower)ApoliPowers.MODIFY_STATUS_EFFECT_AMPLIFIER.get(), originalAmp, power -> ModifyStatusEffectPower.doesApply((ConfiguredPower)power.m_203334_(), effectType)));
        int duration = Math.round(IPowerContainer.modify(this, (ModifyStatusEffectPower)ApoliPowers.MODIFY_STATUS_EFFECT_DURATION.get(), originalDur, power -> ModifyStatusEffectPower.doesApply((ConfiguredPower)power.m_203334_(), effectType)));
        if (amplifier != originalAmp || duration != originalDur) {
            return new MobEffectInstance(effectType, duration, amplifier, effect.m_19571_(), effect.m_19572_(), effect.m_19575_(), ((HiddenEffectStatus)effect).getHiddenEffect(), effect.m_216895_());
        }
        return effect;
    }

    @Inject(method={"setLastHurtByMob"}, at={@At(value="TAIL")})
    private void syncAttacker(LivingEntity attacker, CallbackInfo ci) {
        if (!this.m_9236_().m_5776_()) {
            ApoliCommon.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new S2CSyncAttacker(this.m_19879_(), attacker != null ? OptionalInt.of(attacker.m_19879_()) : OptionalInt.empty()));
        }
    }

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeMap;removeAttributeModifiers(Lcom/google/common/collect/Multimap;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void removeEquipmentPowers(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir, Map<EquipmentSlot, ItemStack> map, EquipmentSlot[] var2, int var3, int var4, EquipmentSlot equipmentSlot, ItemStack itemStack3, ItemStack itemStack4) {
        List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(itemStack3, equipmentSlot);
        if (powers.size() > 0) {
            ResourceLocation source = new ResourceLocation("apoli", equipmentSlot.m_20751_());
            IPowerContainer.get(this).ifPresent(container -> {
                powers.forEach(sp -> container.removePower(sp.powerId, source));
                container.sync();
            });
        }
    }

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeMap;addTransientAttributeModifiers(Lcom/google/common/collect/Multimap;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addEquipmentPowers(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir, Map<EquipmentSlot, ItemStack> map, EquipmentSlot[] var2, int var3, int var4, EquipmentSlot equipmentSlot, ItemStack itemStack3, ItemStack itemStack4) {
        List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers(itemStack4, equipmentSlot);
        if (powers.size() > 0) {
            ResourceLocation source = new ResourceLocation("apoli", equipmentSlot.m_20751_());
            IPowerContainer.get(this).ifPresent(container -> {
                powers.forEach(sp -> container.addPower(sp.powerId, source));
                container.sync();
            });
        } else if (StackPowerUtil.getPowers(itemStack3, equipmentSlot).size() > 0) {
            IPowerContainer.sync(this);
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyWalkableFluids(FluidState fluid, CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.getPowers(this, (WalkOnFluidPower)ApoliPowers.WALK_ON_FLUID.get()).stream().anyMatch(p -> fluid.m_205070_(((TagConfiguration)((ConfiguredPower)p.m_203334_()).getConfiguration()).value()))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public List<Holder<ConfiguredPower<ModifyDamageTakenConfiguration, ModifyDamageTakenPower>>> getModifyDamageTakenPowers() {
        return this.apoli$damageMods;
    }

    @Override
    public List<Holder<ConfiguredPower<ModifyDamageDealtConfiguration, ModifyDamageDealtPower>>> getModifyDamageDealtPowers() {
        return this.apoli$damageSourceMods;
    }

    @Override
    public void setModifyDamageTakenPowers(List<Holder<ConfiguredPower<ModifyDamageTakenConfiguration, ModifyDamageTakenPower>>> values) {
        this.apoli$damageMods = values;
    }

    @Override
    public void setModifyDamageDealtPowers(List<Holder<ConfiguredPower<ModifyDamageDealtConfiguration, ModifyDamageDealtPower>>> values) {
        this.apoli$damageSourceMods = values;
    }

    @Override
    public void bypassDamageCheck(boolean value) {
        this.apoli$bypassDamageCheck = value;
    }

    @Override
    public boolean bypassesDamageCheck() {
        return this.apoli$bypassDamageCheck;
    }

    @Override
    public void setArmorValues(int apply, int damage) {
        this.apoli$shouldApplyArmor = apply;
        this.apoli$shouldDamageArmor = damage;
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyArmorApplicance(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        if (this.apoli$shouldApplyArmor != 0) {
            if (this.apoli$shouldDamageArmor > 0) {
                this.m_6472_(source, amount);
            }
            if (this.apoli$shouldApplyArmor > 0) {
                if (this.apoli$shouldDamageArmor == 0) {
                    this.m_6472_(source, amount);
                }
                float damageLeft = CombatRules.m_19272_((float)amount, (float)this.m_21230_(), (float)((float)this.m_21133_(Attributes.f_22285_)));
                cir.setReturnValue((Object)Float.valueOf(damageLeft));
            } else {
                cir.setReturnValue((Object)Float.valueOf(amount));
            }
        } else if (this.apoli$shouldDamageArmor > 0 && source.m_269533_(DamageTypeTags.f_268490_)) {
            this.m_6472_(source, amount);
        }
    }

    @ModifyArg(method={"getDamageAfterArmorAbsorb"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtArmor(Lnet/minecraft/world/damagesource/DamageSource;F)V"), index=1)
    private float preventArmorDamaging(float amount) {
        if (this.apoli$shouldDamageArmor < 0) {
            return 0.0f;
        }
        return amount;
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWaterRainOrBubble()Z"))
    private boolean preventExtinguishingFromSwimming(LivingEntity livingEntity) {
        if (livingEntity.m_6069_() && this.getFluidTypeHeight((FluidType)ForgeMod.WATER_TYPE.get()) <= 0.0 && IPowerContainer.hasPower((Entity)livingEntity, (DummyPower)ApoliPowers.SWIMMING.get())) {
            return false;
        }
        return livingEntity.m_20071_();
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getTicksFrozen()I")})
    private void freezeEntityFromPower(CallbackInfo ci) {
        if (IPowerContainer.hasPower(this, (DummyPower)ApoliPowers.FREEZE.get())) {
            this.prevPowderSnowState = this.f_146808_;
            this.f_146808_ = true;
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInFluidType(Lnet/minecraft/world/level/material/FluidState;)Z"))
    private boolean dontCountEntityAsInFluid(LivingEntity instance, FluidState fluidState) {
        if (fluidState.getFluidType() == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return instance.isInFluidType(fluidState);
    }

    @ModifyVariable(method={"aiStep"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    private FluidType allowJumpingInIgnoredWater(FluidType fluidType) {
        if (IPowerContainer.hasPower(this, (DummyPower)ApoliPowers.IGNORE_WATER.get())) {
            return (FluidType)ForgeMod.EMPTY_TYPE.get();
        }
        return fluidType;
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;removeFrost()V")})
    private void unfreezeEntityFromPower(CallbackInfo ci) {
        if (IPowerContainer.hasPower(this, (DummyPower)ApoliPowers.FREEZE.get())) {
            this.f_146808_ = this.prevPowderSnowState;
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="RETURN")}, cancellable=true)
    private void allowFreezingPower(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower(this, (DummyPower)ApoliPowers.FREEZE.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")})
    private void sendPlayerDismountPacket(CallbackInfo ci) {
        Entity entity;
        if (!this.m_9236_().m_5776_() && (entity = this.m_20202_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ApoliCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CPlayerDismount(this.m_19879_()));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getMobType"}, cancellable=true)
    public void getGroup(CallbackInfoReturnable<MobType> info) {
        List powers = IPowerContainer.getPowers(this, (EntityGroupPower)ApoliPowers.ENTITY_GROUP.get());
        if (powers.size() > 0) {
            if (powers.size() > 1) {
                Apoli.LOGGER.warn("Entity " + this.m_5446_() + " has two instances of SetEntityGroupPower.");
            }
            info.setReturnValue((Object)((MobType)((FieldConfiguration)((ConfiguredPower)powers.get(0).m_203334_()).getConfiguration()).value()));
        }
    }

    @Inject(method={"getAttributeValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyAttributeValue(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        double modified;
        double originalValue = this.m_21204_().m_22181_(attribute);
        if (originalValue != (modified = (double)IPowerContainer.modify(this, (ModifyAttributePower)ApoliPowers.MODIFY_ATTRIBUTE.get(), (float)originalValue, p -> ((ModifyAttributeConfiguration)((ConfiguredPower)p.get()).getConfiguration()).attribute() == attribute))) {
            cir.setReturnValue((Object)modified);
        }
    }

    @Inject(method={"getAttribute"}, at={@At(value="RETURN")})
    private void setEntityToAttributeInstance(Attribute attribute, CallbackInfoReturnable<AttributeInstance> cir) {
        AttributeInstance instance = (AttributeInstance)cir.getReturnValue();
        if (instance != null) {
            ((EntityAttributeInstanceAccess)instance).setEntity(this);
        }
    }

    @Inject(method={"doPush"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPushing(Entity entity, CallbackInfo ci) {
        if (BiEntityConditionPower.any((BiEntityConditionPower)ApoliPowers.PREVENT_ENTITY_COLLISION.get(), this, this, entity) || BiEntityConditionPower.any((BiEntityConditionPower)ApoliPowers.PREVENT_ENTITY_COLLISION.get(), entity, entity, this)) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"eat"}, at=@At(value="HEAD"), argsOnly=true)
    private ItemStack modifyEatenItemStack(ItemStack original) {
        if (this instanceof Player) {
            return original;
        }
        List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> mfps = ModifyFoodPower.getValidPowers(this, original);
        MutableObject stack = new MutableObject((Object)original.m_41777_());
        ModifyFoodPower.modifyStack(mfps, this.m_9236_(), (Mutable<ItemStack>)stack);
        this.setCurrentModifyFoodPowers(mfps);
        this.setOriginalFoodStack(original);
        return (ItemStack)stack.getValue();
    }

    @ModifyVariable(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", shift=At.Shift.AFTER), argsOnly=true)
    private ItemStack unmodifyEatenItemStack(ItemStack modified) {
        LivingEntityMixin foodEntity = this;
        ItemStack original = foodEntity.getOriginalFoodStack();
        if (original != null) {
            foodEntity.setOriginalFoodStack(null);
            return original;
        }
        return modified;
    }

    @Inject(method={"releaseUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onUseItemStop(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;I)Z")})
    private void callActionOnUseStopBefore(CallbackInfo ci) {
        if (ApoliAPI.getPowerContainer(this) != null && ApoliAPI.getPowerContainer(this).getPowers((ActionOnItemUsePower)ApoliPowers.ACTION_ON_ITEM_USE.get()).stream().anyMatch(p -> p.m_203633_() && ((ActionOnItemUsePower)((ConfiguredPower)p.m_203334_()).getFactory()).canRun((Holder<ConfiguredPower<ActionOnItemUseConfiguration, ActionOnItemUsePower>>)p, this, this.f_20935_, ActionOnItemUseConfiguration.TriggerType.STOP, ActionOnItemUseConfiguration.PriorityPhase.BEFORE))) {
            Mutable<ItemStack> mutable = VariableAccess.hand((LivingEntity)this, this.m_7655_());
            ActionOnItemUsePower.execute(this, this.f_20935_, mutable, ActionOnItemUseConfiguration.TriggerType.STOP, ActionOnItemUseConfiguration.PriorityPhase.BEFORE);
            this.f_20935_ = (ItemStack)mutable.getValue();
        }
    }

    @ModifyVariable(method={"updateUsingItem"}, at=@At(value="HEAD"), argsOnly=true)
    private ItemStack callActionOnUseDuringBefore(ItemStack original) {
        if (ApoliAPI.getPowerContainer(this) != null && ApoliAPI.getPowerContainer(this).getPowers((ActionOnItemUsePower)ApoliPowers.ACTION_ON_ITEM_USE.get()).stream().anyMatch(p -> p.m_203633_() && ((ActionOnItemUsePower)((ConfiguredPower)p.m_203334_()).getFactory()).canRun((Holder<ConfiguredPower<ActionOnItemUseConfiguration, ActionOnItemUsePower>>)p, this, original, ActionOnItemUseConfiguration.TriggerType.DURING, ActionOnItemUseConfiguration.PriorityPhase.BEFORE))) {
            Mutable<ItemStack> mutable = VariableAccess.hand((LivingEntity)this, this.m_7655_());
            ActionOnItemUsePower.execute(this, original, mutable, ActionOnItemUseConfiguration.TriggerType.DURING, ActionOnItemUseConfiguration.PriorityPhase.BEFORE);
            if (!ItemStack.m_41728_((ItemStack)((ItemStack)mutable.getValue()), (ItemStack)original)) {
                return (ItemStack)mutable.getValue();
            }
        }
        return original;
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V")})
    private void callActionOnUseFinishBefore(CallbackInfo ci) {
        if (ApoliAPI.getPowerContainer(this) != null && ApoliAPI.getPowerContainer(this).getPowers((ActionOnItemUsePower)ApoliPowers.ACTION_ON_ITEM_USE.get()).stream().anyMatch(p -> p.m_203633_() && ((ActionOnItemUsePower)((ConfiguredPower)p.m_203334_()).getFactory()).canRun((Holder<ConfiguredPower<ActionOnItemUseConfiguration, ActionOnItemUsePower>>)p, this, this.f_20935_, ActionOnItemUseConfiguration.TriggerType.FINISH, ActionOnItemUseConfiguration.PriorityPhase.BEFORE))) {
            MutableObject mutable = new MutableObject((Object)this.f_20935_);
            ActionOnItemUsePower.execute(this, this.f_20935_, (Mutable<ItemStack>)mutable, ActionOnItemUseConfiguration.TriggerType.FINISH, ActionOnItemUseConfiguration.PriorityPhase.BEFORE);
            this.f_20935_ = (ItemStack)mutable.getValue();
        }
    }

    @Inject(method={"eat"}, at={@At(value="TAIL")})
    private void removeCurrentModifyFoodPowers(Level world, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        this.setCurrentModifyFoodPowers(new LinkedList<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>>());
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V"))
    private void preventApplyingFoodEffects(LivingEntity livingEntity, ItemStack stack, Level world, LivingEntity targetEntity) {
        if (this.getCurrentModifyFoodPowers().stream().anyMatch(x -> ((ModifyFoodConfiguration)x.getConfiguration()).preventEffects())) {
            return;
        }
        this.m_21063_(stack, world, targetEntity);
    }

    @Shadow
    protected abstract void m_21063_(ItemStack var1, Level var2, LivingEntity var3);

    @Shadow
    protected abstract void m_6472_(DamageSource var1, float var2);

    @Shadow
    public abstract int m_21230_();

    @Shadow
    public abstract double m_21133_(Attribute var1);

    @Shadow
    public abstract AttributeMap m_21204_();

    @Shadow
    protected abstract float m_274460_();

    @Shadow
    public abstract InteractionHand m_7655_();

    @Inject(method={"getFrictionInfluencedSpeed(F)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyFlySpeed(float slipperiness, CallbackInfoReturnable<Float> cir) {
        if (!this.m_20096_()) {
            cir.setReturnValue((Object)Float.valueOf(IPowerContainer.modify((Entity)this, (ModifyValuePower)ApoliPowers.MODIFY_AIR_SPEED.get(), this.m_274460_())));
        }
    }

    @Override
    public List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> getCurrentModifyFoodPowers() {
        return this.apoli$currentModifyFoodPowers;
    }

    @Override
    public void setCurrentModifyFoodPowers(List<ConfiguredPower<ModifyFoodConfiguration, ModifyFoodPower>> powers) {
        this.apoli$currentModifyFoodPowers = powers;
    }

    @Override
    public ItemStack getOriginalFoodStack() {
        return this.apoli$originalFoodStack;
    }

    @Override
    public void setOriginalFoodStack(ItemStack original) {
        this.apoli$originalFoodStack = original;
    }

    @Override
    public void enforceFoodSync() {
        this.apoli$shouldSyncFoodData = true;
    }

    @Override
    public void resetFoodSync() {
        this.apoli$shouldSyncFoodData = false;
    }

    @Override
    public boolean shouldSyncFood() {
        return this.apoli$shouldSyncFoodData;
    }
}

