/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.PowerModifiedGrindstone;
import io.github.apace100.apoli.mixin.forge.GrindstoneMenuResultSlotAccessor;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyGrindstonePower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyGrindstoneConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GrindstoneMenu.class})
public abstract class GrindstoneScreenHandlerMixin
extends AbstractContainerMenu
implements PowerModifiedGrindstone {
    @Shadow
    @Final
    private Container f_39559_;
    @Shadow(remap=false)
    private int xp;
    @Unique
    private Player apoli$cachedPlayer;
    @Unique
    private Optional<BlockPos> apoli$cachedPosition;
    @Unique
    private List<Holder<ConfiguredPower<ModifyGrindstoneConfiguration, ModifyGrindstonePower>>> apoli$appliedPowers = new ArrayList<Holder<ConfiguredPower<ModifyGrindstoneConfiguration, ModifyGrindstonePower>>>();
    @Unique
    int apoli$cachedPIndex;

    protected GrindstoneScreenHandlerMixin(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="RETURN")})
    private void cachePlayer(int syncId, Inventory playerInventory, ContainerLevelAccess context, CallbackInfo ci) {
        this.apoli$cachedPlayer = playerInventory.f_35978_;
        this.apoli$cachedPosition = context.m_6721_((w, bp) -> bp);
    }

    @Inject(method={"createResult"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void modifyResult(CallbackInfo ci, ItemStack top, ItemStack bottom) {
        this.apoli$appliedPowers.clear();
        List<Holder<ConfiguredPower<ModifyGrindstoneConfiguration, ModifyGrindstonePower>>> applyingPowers = ModifyGrindstonePower.tryGetApplyingPowers((Entity)this.apoli$cachedPlayer, top, bottom, this.f_39559_.m_8020_(0), this.apoli$cachedPosition);
        if (applyingPowers.isEmpty()) {
            return;
        }
        this.apoli$appliedPowers = applyingPowers;
        ItemStack newOutput = ModifyGrindstonePower.tryCreateOutput(this.apoli$appliedPowers, this.apoli$cachedPlayer.m_9236_(), top, bottom, this.f_39559_.m_8020_(0));
        this.f_39559_.m_6836_(0, newOutput);
        this.xp = (int)ModifierUtil.applyModifiers((Entity)this.apoli$cachedPlayer, ModifyGrindstonePower.tryGetExperienceModifiers(applyingPowers), (double)((GrindstoneMenuResultSlotAccessor)this.m_38853_(2)).invokeGetExperienceAmount(this.apoli$cachedPlayer.m_9236_()));
        this.m_38946_();
    }

    @Inject(method={"quickMoveStack"}, at={@At(value="HEAD")})
    private void cacheMouseX(Player pPlayer, int pIndex, CallbackInfoReturnable<ItemStack> cir) {
        this.apoli$cachedPIndex = pIndex;
    }

    @ModifyVariable(method={"quickMoveStack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;copy()Lnet/minecraft/world/item/ItemStack;"), ordinal=1)
    private ItemStack handleGrindstoneLateActionsQuickMove(ItemStack original) {
        if (this.apoli$cachedPIndex == 2) {
            MutableObject newStack = new MutableObject((Object)original.m_41777_());
            ModifyGrindstonePower.tryLateExecute(this.apoli$appliedPowers, (Entity)this.apoli$cachedPlayer, (Mutable<ItemStack>)newStack, this.apoli$cachedPosition);
            return (ItemStack)newStack.getValue();
        }
        return original;
    }

    @Override
    public List<Holder<ConfiguredPower<ModifyGrindstoneConfiguration, ModifyGrindstonePower>>> getAppliedPowers() {
        return this.apoli$appliedPowers;
    }

    @Override
    public Player getPlayer() {
        return this.apoli$cachedPlayer;
    }

    @Override
    public Optional<BlockPos> getPos() {
        return this.apoli$cachedPosition;
    }
}

