/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.INightVisionPower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyCameraSubmersionTypePower;
import io.github.edwinmindcraft.apoli.common.power.PhasingPower;
import io.github.edwinmindcraft.apoli.common.power.ShaderPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.PhasingConfiguration;
import io.github.edwinmindcraft.apoli.common.power.configuration.ShaderConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    private final HashMap<BlockPos, BlockState> savedStates = new HashMap();
    @Shadow
    @Final
    private Camera f_109054_;
    @Shadow
    @Final
    private Minecraft f_109059_;
    @Unique
    private ResourceLocation currentlyLoadedShader;
    @Shadow
    @Final
    private ResourceManager f_109060_;
    @Shadow
    @Nullable
    private PostChain f_109050_;
    @Shadow
    private boolean f_109053_;

    @Shadow
    public abstract void m_109128_(ResourceLocation var1);

    @Shadow
    public abstract Minecraft m_172797_();

    @Inject(at={@At(value="TAIL")}, method={"checkEntityPostEffect"})
    private void loadShaderFromPowerOnCameraEntity(Entity entity, CallbackInfo ci) {
        if (ApoliPowers.SHADER.isPresent()) {
            IPowerContainer.withPower(this.f_109059_.m_91288_(), (ShaderPower)ApoliPowers.SHADER.get(), null, shaderPower -> {
                ResourceLocation shaderLoc = ((ShaderConfiguration)((ConfiguredPower)shaderPower.m_203334_()).getConfiguration()).shader();
                if (this.f_109060_.m_213713_(shaderLoc).isPresent()) {
                    this.m_109128_(shaderLoc);
                    this.currentlyLoadedShader = shaderLoc;
                }
            });
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void loadShaderFromPower(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        if (ApoliPowers.SHADER.isPresent()) {
            IPowerContainer.withPower(this.f_109059_.m_91288_(), (ShaderPower)ApoliPowers.SHADER.get(), null, shaderPower -> {
                ResourceLocation shaderLoc;
                if (shaderPower.m_203633_() && this.currentlyLoadedShader != (shaderLoc = ((ShaderConfiguration)((ConfiguredPower)shaderPower.get()).getConfiguration()).shader())) {
                    this.m_109128_(shaderLoc);
                    this.currentlyLoadedShader = shaderLoc;
                }
            });
            if (!IPowerContainer.hasPower(this.f_109059_.m_91288_(), (ShaderPower)ApoliPowers.SHADER.get()) && this.currentlyLoadedShader != null) {
                if (this.f_109050_ != null) {
                    this.f_109050_.close();
                    this.f_109050_ = null;
                }
                this.f_109053_ = false;
                this.currentlyLoadedShader = null;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"togglePostEffect"}, cancellable=true)
    private void disableShaderToggle(CallbackInfo ci) {
        if (IPowerContainer.getPowers(this.m_172797_().f_91075_, (ShaderPower)ApoliPowers.SHADER.get()).stream().anyMatch(power -> !((ShaderConfiguration)((ConfiguredPower)power.m_203334_()).getConfiguration()).toggleable() && ((ShaderConfiguration)((ConfiguredPower)power.m_203334_()).getConfiguration()).shader().equals((Object)this.currentlyLoadedShader))) {
            ci.cancel();
        }
    }

    @Redirect(method={"getNightVisionScale"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;endsWithin(I)Z"))
    private static boolean fixNightVision(MobEffectInstance instance, int pDuration) {
        if (instance != null) {
            return instance.m_267633_(pDuration);
        }
        return false;
    }

    @Redirect(method={"getNightVisionScale"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;getDuration()I"))
    private static int extraFixNightVision(MobEffectInstance instance) {
        if (instance != null) {
            return instance.m_19557_();
        }
        return 0;
    }

    @Inject(at={@At(value="RETURN")}, method={"getNightVisionScale"}, cancellable=true)
    private static void updateNightVisionScale(LivingEntity living, float tickDelta, CallbackInfoReturnable<Float> cir) {
        if (!living.m_21023_(MobEffects.f_19611_)) {
            INightVisionPower.getNightVisionStrength((Entity)living).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
        }
    }

    @Redirect(method={"getFov"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;getFluidInCamera()Lnet/minecraft/world/level/material/FogType;"))
    private FogType modifySubmersionType(Camera camera) {
        FogType original = camera.m_167685_();
        return ModifyCameraSubmersionTypePower.tryReplace(camera.m_90592_(), original).orElse(original);
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void beforeRender(float tickDelta, long startTime, boolean tick, CallbackInfo info) {
        block7: {
            ClientLevel level;
            block6: {
                if (!ApoliPowers.PHASING.isPresent()) {
                    return;
                }
                Optional<Float> renderMethod = PhasingPower.getRenderMethod(this.f_109054_.m_90592_(), PhasingConfiguration.RenderType.REMOVE_BLOCKS);
                level = this.f_109059_.f_91073_;
                if (level == null) {
                    return;
                }
                if (!renderMethod.isPresent()) break block6;
                Set<BlockPos> eyePositions = this.getEyePos(0.25f, 0.05f, 0.25f);
                HashSet<BlockPos> noLongerEyePositions = new HashSet<BlockPos>();
                for (BlockPos p : this.savedStates.keySet()) {
                    if (eyePositions.contains(p)) continue;
                    noLongerEyePositions.add(p);
                }
                for (BlockPos eyePosition : noLongerEyePositions) {
                    BlockState state = this.savedStates.get(eyePosition);
                    level.m_46597_(eyePosition, state);
                    this.savedStates.remove(eyePosition);
                }
                for (BlockPos p : eyePositions) {
                    BlockState stateAtP = level.m_8055_(p);
                    if (this.savedStates.containsKey(p) || level.m_46859_(p) || stateAtP.m_60734_() instanceof LiquidBlock) continue;
                    this.savedStates.put(p, stateAtP);
                    level.m_46597_(p, Blocks.f_50016_.m_49966_());
                }
                break block7;
            }
            if (this.savedStates.size() <= 0) break block7;
            HashSet<BlockPos> noLongerEyePositions = new HashSet<BlockPos>(this.savedStates.keySet());
            for (BlockPos eyePosition : noLongerEyePositions) {
                BlockState state = this.savedStates.get(eyePosition);
                level.m_46597_(eyePosition, state);
                this.savedStates.remove(eyePosition);
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"), method={"renderLevel"})
    private void preventThirdPerson(Camera camera, BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta) {
        if (ApoliPowers.PHASING.isPresent() && PhasingPower.hasRenderMethod(camera.m_90592_(), PhasingConfiguration.RenderType.REMOVE_BLOCKS)) {
            camera.m_90575_(area, focusedEntity, false, false, tickDelta);
        } else {
            camera.m_90575_(area, focusedEntity, thirdPerson, inverseView, tickDelta);
        }
    }

    private Set<BlockPos> getEyePos(float rangeX, float rangeY, float rangeZ) {
        Vec3 pos = this.f_109054_.m_90592_().m_20182_().m_82520_(0.0, (double)this.f_109054_.m_90592_().m_20236_(this.f_109054_.m_90592_().m_20089_()), 0.0);
        AABB cameraBox = new AABB(pos, pos);
        cameraBox = cameraBox.m_82377_((double)rangeX, (double)rangeY, (double)rangeZ);
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        BlockPos.m_121921_((AABB)cameraBox).forEach(p -> set.add(p.m_7949_()));
        return set;
    }
}

