/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.MovingEntity;
import io.github.apace100.apoli.access.SubmergableEntity;
import io.github.apace100.apoli.access.WaterMovingEntity;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.GroundedPower;
import io.github.edwinmindcraft.apoli.common.power.InvisibilityPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyVelocityPower;
import io.github.edwinmindcraft.apoli.common.power.PhasingPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyVelocityConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements MovingEntity,
SubmergableEntity {
    @Shadow
    public Level f_19853_;
    @Shadow
    public float f_19788_;
    @Shadow
    protected Object2DoubleMap<TagKey<Fluid>> f_19799_;
    private boolean isMoving;
    private float distanceBefore;
    @Shadow
    protected boolean f_19861_;
    @Final
    @Shadow
    private Set<TagKey<Fluid>> f_19801_;

    @Inject(method={"fireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeFullyFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower((Entity)this, (DummyPower)ApoliPowers.FIRE_IMMUNITY.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract double m_204036_(TagKey<Fluid> var1);

    @Inject(method={"isInWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeEntitiesIgnoreWater(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower((Entity)this, (DummyPower)ApoliPowers.IGNORE_WATER.get()) && this instanceof WaterMovingEntity && ((WaterMovingEntity)((Object)this)).isInMovementPhase()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;isInWaterRainOrBubble()Z"))
    private boolean preventExtinguishingFromSwimming(Entity entity) {
        if (entity.m_6069_() && this.m_204036_((TagKey<Fluid>)FluidTags.f_13131_) <= 0.0 && IPowerContainer.hasPower(entity, (DummyPower)ApoliPowers.SWIMMING.get())) {
            return false;
        }
        return entity.m_20071_();
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvisible"}, cancellable=true)
    private void phantomInvisibility(CallbackInfoReturnable<Boolean> info) {
        if (IPowerContainer.hasPower((Entity)this, (InvisibilityPower)ApoliPowers.INVISIBILITY.get())) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"moveTowardsClosestSpace"}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfo info) {
        if (PhasingPower.shouldPhaseThrough((Entity)this, new BlockPos((int)x, (int)y, (int)z))) {
            info.cancel();
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void saveDistanceTraveled(MoverType type, Vec3 movement, CallbackInfo ci) {
        this.isMoving = false;
        this.distanceBefore = this.f_19788_;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V")})
    private void checkIsMoving(MoverType type, Vec3 movement, CallbackInfo ci) {
        if (this.f_19788_ > this.distanceBefore) {
            this.isMoving = true;
        }
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), argsOnly=true)
    private Vec3 modifyMovementVelocityXZ(Vec3 vec, MoverType movementType) {
        if (!IPowerContainer.hasPower((Entity)this, (ModifyVelocityPower)ApoliPowers.MODIFY_VELOCITY.get()) || movementType != MoverType.SELF) {
            return vec;
        }
        double x = IPowerContainer.modify((Entity)this, (ModifyVelocityPower)ApoliPowers.MODIFY_VELOCITY.get(), (float)vec.f_82479_, p -> ((ModifyVelocityConfiguration)((ConfiguredPower)p.m_203334_()).getConfiguration()).axes().contains(Direction.Axis.X));
        double y = IPowerContainer.modify((Entity)this, (ModifyVelocityPower)ApoliPowers.MODIFY_VELOCITY.get(), (float)vec.f_82480_, p -> ((ModifyVelocityConfiguration)((ConfiguredPower)p.m_203334_()).getConfiguration()).axes().contains(Direction.Axis.Y));
        double z = IPowerContainer.modify((Entity)this, (ModifyVelocityPower)ApoliPowers.MODIFY_VELOCITY.get(), (float)vec.f_82481_, p -> ((ModifyVelocityConfiguration)((ConfiguredPower)p.m_203334_()).getConfiguration()).axes().contains(Direction.Axis.Z));
        return new Vec3(x, y, z);
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getOnPosLegacy()Lnet/minecraft/core/BlockPos;")})
    private void forceGrounded(MoverType pType, Vec3 pPos, CallbackInfo ci) {
        if (IPowerContainer.hasPower((Entity)this, (GroundedPower)ApoliPowers.GROUNDED.get())) {
            this.f_19861_ = true;
        }
    }

    @Override
    public boolean isSubmergedInLoosely(TagKey<Fluid> tag) {
        if (tag == null || this.f_19801_ == null) {
            return false;
        }
        return this.f_19801_.contains(tag);
    }

    @Override
    public double getFluidHeightLoosely(TagKey<Fluid> tag) {
        if (tag == null) {
            return 0.0;
        }
        if (this.f_19799_.containsKey(tag)) {
            return this.f_19799_.getDouble(tag);
        }
        for (TagKey ft : this.f_19799_.keySet()) {
            if (!ft.equals(tag)) continue;
            return this.f_19799_.getDouble((Object)ft);
        }
        return 0.0;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }
}

