/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.PowerCraftingInventory;
import io.github.apace100.apoli.util.ModifiedCraftingRecipe;
import io.github.edwinmindcraft.apoli.common.power.configuration.ModifyCraftingConfiguration;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingMenu.class})
public class CraftingScreenHandlerMixin {
    @Shadow
    @Final
    public ContainerLevelAccess f_39350_;
    @Shadow
    @Final
    private CraftingContainer f_39348_;
    @Shadow
    @Final
    private Player f_39351_;

    @Inject(method={"slotChangedCraftingGrid"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeManager;getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;")})
    private static void clearPowerCraftingInventory(AbstractContainerMenu menu, Level level, Player player, CraftingContainer container, ResultContainer result, CallbackInfo ci) {
        if (container instanceof PowerCraftingInventory) {
            ((PowerCraftingInventory)container).setPower(null);
        }
    }

    @ModifyVariable(method={"quickMoveStack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;copy()Lnet/minecraft/world/item/ItemStack;"), ordinal=1)
    private ItemStack modifyOutputItems(ItemStack stack) {
        Object object = this.f_39348_;
        if (object instanceof TransientCraftingContainer) {
            PowerCraftingInventory pci;
            TransientCraftingContainer craftingContainer = (TransientCraftingContainer)object;
            if (!this.f_39351_.m_9236_().f_46443_ && (object = this.f_39348_) instanceof PowerCraftingInventory && (pci = (PowerCraftingInventory)object).getPower() != null && (object = pci.getPower().getConfiguration()) instanceof ModifyCraftingConfiguration) {
                ModifyCraftingConfiguration config = (ModifyCraftingConfiguration)object;
                Optional<BlockPos> blockPos = ModifiedCraftingRecipe.getBlockFromInventory(craftingContainer);
                MutableObject newStack = new MutableObject((Object)stack);
                config.execute((Entity)this.f_39351_, blockPos.orElse(null));
                config.executeAfterCraftingAction(this.f_39351_.m_9236_(), (Mutable<ItemStack>)newStack);
                return (ItemStack)newStack.getValue();
            }
        }
        return stack;
    }

    @Inject(method={"stillValid"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowUsingViaPower(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)this.f_39350_.m_39299_((world, pos) -> pos.equals((Object)player.m_20183_()), (Object)false)).booleanValue()) {
            cir.setReturnValue((Object)true);
        }
    }
}

