/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.mojang.authlib.GameProfile;
import io.github.apace100.apoli.access.WaterMovingEntity;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValuePower;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
extends AbstractClientPlayer
implements WaterMovingEntity {
    private boolean isMoving = false;

    public ClientPlayerEntityMixin(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(at={@At(value="HEAD")}, method={"isUnderWater"}, cancellable=true)
    private void allowSwimming(CallbackInfoReturnable<Boolean> cir) {
        LazyOptional<IPowerContainer> lazyContainer = IPowerContainer.get((Entity)this);
        if (!lazyContainer.isPresent()) {
            return;
        }
        IPowerContainer container = (IPowerContainer)lazyContainer.orElseThrow(RuntimeException::new);
        if (container.hasPower((PowerFactory)ApoliPowers.SWIMMING.get())) {
            cir.setReturnValue((Object)true);
        } else if (container.hasPower((PowerFactory)ApoliPowers.IGNORE_WATER.get())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"aiStep"})
    private void beginMovementPhase(CallbackInfo ci) {
        this.isMoving = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"aiStep"})
    private void endMovementPhase(CallbackInfo ci) {
        this.isMoving = false;
    }

    @Override
    public boolean isInMovementPhase() {
        return this.isMoving;
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Abilities;getFlyingSpeed()F"))
    private float modifyFlySpeed(Abilities playerAbilities) {
        return IPowerContainer.modify((Entity)this, (ModifyValuePower)ApoliPowers.MODIFY_AIR_SPEED.get(), playerAbilities.m_35942_());
    }

    @Inject(method={"hasEnoughFoodToStartSprinting"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifySprintAbility(CallbackInfoReturnable<Boolean> cir) {
        if (IPowerContainer.hasPower((Entity)this, (DummyPower)ApoliPowers.PREVENT_SPRINTING.get())) {
            cir.setReturnValue((Object)false);
        }
    }
}

