/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.global;

import io.github.apace100.apoli.Apoli;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.apoli.common.ApoliEventHandler;
import io.github.edwinmindcraft.apoli.common.global.GlobalPowerSet;
import io.github.edwinmindcraft.calio.api.CalioAPI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class GlobalPowerSetUtil {
    public static ResourceLocation POWER_SOURCE = Apoli.identifier("global");

    public static List<GlobalPowerSet> getApplicableSets(EntityType<?> type) {
        LinkedList<GlobalPowerSet> result = new LinkedList<GlobalPowerSet>();
        Iterator sets = CalioAPI.getDynamicRegistries().get(ApoliDynamicRegistries.GLOBAL_POWER_SET).m_123024_().iterator();
        while (sets.hasNext()) {
            GlobalPowerSet gps = (GlobalPowerSet)sets.next();
            if (!gps.doesApply(type)) continue;
            result.add(gps);
        }
        result.sort(GlobalPowerSet::compareTo);
        return result;
    }

    public static Set<ResourceLocation> getPowerTypeIds(List<GlobalPowerSet> powerSets) {
        return powerSets.stream().flatMap(gps -> gps.powers().stream()).map(ResourceKey::m_135782_).collect(Collectors.toSet());
    }

    public static void applyGlobalPowers(Entity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        IPowerContainer pc = ApoliAPI.getPowerContainer(entity);
        if (pc == null) {
            return;
        }
        List<GlobalPowerSet> sets = GlobalPowerSetUtil.getApplicableSets(entity.m_6095_());
        Set<ResourceLocation> ids = GlobalPowerSetUtil.getPowerTypeIds(sets);
        boolean change = GlobalPowerSetUtil.removeExcessPowers(pc, ids);
        for (GlobalPowerSet powerSet : sets) {
            change |= GlobalPowerSetUtil.addMissingPowers(pc, powerSet);
        }
        if (change) {
            pc.sync();
        }
    }

    private static boolean removeExcessPowers(IPowerContainer phc, Set<ResourceLocation> expected) {
        List<ResourceKey<ConfiguredPower<?, ?>>> powers = phc.getPowersFromSource(POWER_SOURCE);
        LinkedList toRemove = new LinkedList();
        for (ResourceKey<ConfiguredPower<?, ?>> resourceKey : powers) {
            ResourceLocation id = resourceKey.m_135782_();
            if (expected.contains(id)) continue;
            toRemove.add(resourceKey);
        }
        for (ResourceKey resourceKey : toRemove) {
            phc.removePower(resourceKey, POWER_SOURCE);
        }
        return toRemove.size() > 0;
    }

    private static boolean addMissingPowers(IPowerContainer phc, GlobalPowerSet powerSet) {
        boolean added = false;
        for (ResourceKey<ConfiguredPower<?, ?>> pt : powerSet.powers()) {
            if (ApoliEventHandler.isPowerDisabled(pt.m_135782_()) || phc.hasPower(pt, POWER_SOURCE)) continue;
            phc.addPower(pt, POWER_SOURCE);
            added = true;
        }
        return added;
    }
}

