/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.data;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.NameMutableDamageSource;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;

public class DamageSourceDescription {
    public static final Codec<DamageSourceDescription> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(DamageSourceDescription::getName), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"bypasses_armor", (Object)false).forGetter(o -> o.containsTag((TagKey<DamageType>)DamageTypeTags.f_268490_)), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"fire", (Object)false).forGetter(o -> o.containsTag((TagKey<DamageType>)DamageTypeTags.f_268745_)), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"unblockable", (Object)false).forGetter(o -> o.containsTag((TagKey<DamageType>)DamageTypeTags.f_276146_)), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"magic", (Object)false).forGetter(o -> o.containsTag((TagKey<DamageType>)DamageTypeTags.f_268731_)), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"out_of_world", (Object)false).forGetter(o -> o.containsTag((TagKey<DamageType>)DamageTypeTags.f_268738_)), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"projectile", (Object)false).forGetter(o -> o.containsTag((TagKey<DamageType>)DamageTypeTags.f_268524_)), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"explosive", (Object)false).forGetter(o -> o.containsTag((TagKey<DamageType>)DamageTypeTags.f_268415_))).apply((Applicative)instance, DamageSourceDescription::new));
    private static final Set<TagKey<DamageType>> TAGS = Sets.newHashSet();
    private static int TAG_COUNT = 0;
    private final String name;
    private final Set<TagKey<DamageType>> desiredDamageTypeTags = new HashSet<TagKey<DamageType>>();
    private ResourceKey<DamageType> damageType;

    private void registerDamageTypeTagMapping(boolean key, TagKey<DamageType> tag) {
        TAGS.add(tag);
        if (key) {
            this.desiredDamageTypeTags.add(tag);
        }
    }

    public DamageSourceDescription(String name, boolean bypassesArmor, boolean fire, boolean unblockable, boolean magic, boolean outOfWorld, boolean projectile, boolean explosive) {
        this.name = name;
        this.registerDamageTypeTagMapping(bypassesArmor, (TagKey<DamageType>)DamageTypeTags.f_268490_);
        this.registerDamageTypeTagMapping(fire, (TagKey<DamageType>)DamageTypeTags.f_268745_);
        this.registerDamageTypeTagMapping(unblockable, (TagKey<DamageType>)DamageTypeTags.f_276146_);
        this.registerDamageTypeTagMapping(magic, (TagKey<DamageType>)DamageTypeTags.f_268731_);
        this.registerDamageTypeTagMapping(magic, (TagKey<DamageType>)DamageTypeTags.f_268640_);
        this.registerDamageTypeTagMapping(outOfWorld, (TagKey<DamageType>)DamageTypeTags.f_268738_);
        this.registerDamageTypeTagMapping(projectile, (TagKey<DamageType>)DamageTypeTags.f_268524_);
        this.registerDamageTypeTagMapping(explosive, (TagKey<DamageType>)DamageTypeTags.f_268415_);
        if (TAG_COUNT != 0) {
            TAG_COUNT = TAGS.size();
        }
    }

    public String getName() {
        return this.name;
    }

    private boolean containsTag(TagKey<DamageType> tag) {
        return this.desiredDamageTypeTags.contains(tag);
    }

    public Set<TagKey<DamageType>> getDamageTypeTags() {
        return Set.copyOf(this.desiredDamageTypeTags);
    }

    public void addDamageTypeTag(TagKey<DamageType> damageTypeTag) {
        this.desiredDamageTypeTags.add(damageTypeTag);
    }

    public ResourceKey<DamageType> getDamageType(DamageSources damageSources) {
        if (this.damageType == null) {
            this.findBestMatchingDamageType(damageSources);
        }
        return this.damageType;
    }

    public DamageSource create(DamageSources damageSources) {
        DamageSource damageSource = damageSources.m_269079_(this.getDamageType(damageSources));
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    public DamageSource create(DamageSources damageSources, Entity attacker) {
        DamageSource damageSource = damageSources.m_269298_(this.getDamageType(damageSources), attacker);
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    public DamageSource create(DamageSources damageSources, Entity source, Entity attacker) {
        DamageSource damageSource = damageSources.m_268998_(this.getDamageType(damageSources), source, attacker);
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    private void overwriteDamageSourceMessageKey(DamageSource source) {
        ((NameMutableDamageSource)source).setName(this.name);
    }

    private void findBestMatchingDamageType(DamageSources damageSources) {
        Holder bestMatch;
        Optional<Holder.Reference> bestMatchingDamageType = damageSources.f_268645_.m_203611_().max(Comparator.comparingInt(this::getTagMatches));
        if (bestMatchingDamageType.isPresent()) {
            bestMatch = (Holder)bestMatchingDamageType.get();
            int bestMatchTagCount = this.getTagMatches((Holder<DamageType>)bestMatch);
            if (bestMatchTagCount < TAG_COUNT) {
                Apoli.LOGGER.warn("Could not find a perfect damage type for legacy damage source field, best match: {} out of {} tags with damage type \"{}\". Consider creating your own custom damage type.", (Object)bestMatchTagCount, (Object)TAG_COUNT, (Object)bestMatch.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).orElse("<unknown>"));
            }
        } else {
            throw new NoSuchElementException("Damage type registry was empty or not loaded yet");
        }
        this.damageType = (ResourceKey)bestMatch.m_203543_().orElseThrow();
    }

    private int getTagMatches(Holder<DamageType> damageType) {
        int count = 0;
        for (TagKey<DamageType> tag : TAGS) {
            if (damageType.m_203656_(tag) != this.desiredDamageTypeTags.contains(tag)) continue;
            ++count;
        }
        return count;
    }
}

