/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record RaycastSettingsConfiguration(double distance, boolean block, boolean entity, ClipContext.Block shapeType, ClipContext.Fluid fluidHandling) implements IDynamicFeatureConfiguration
{
    public static final MapCodec<RaycastSettingsConfiguration> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CalioCodecHelper.DOUBLE.fieldOf("distance").forGetter(RaycastSettingsConfiguration::distance), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"block", (Object)true).forGetter(RaycastSettingsConfiguration::block), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"entity", (Object)true).forGetter(RaycastSettingsConfiguration::entity), (App)CalioCodecHelper.optionalField((Codec)SerializableDataTypes.SHAPE_TYPE, (String)"shape_type", (Object)ClipContext.Block.OUTLINE).forGetter(RaycastSettingsConfiguration::shapeType), (App)CalioCodecHelper.optionalField((Codec)SerializableDataTypes.FLUID_HANDLING, (String)"fluid_handling", (Object)ClipContext.Fluid.ANY).forGetter(RaycastSettingsConfiguration::fluidHandling)).apply((Applicative)instance, RaycastSettingsConfiguration::new));

    @Override
    public boolean isConfigurationValid() {
        return this.block() || this.entity();
    }

    @NotNull
    public HitResult perform(@NotNull Entity entity, Holder<ConfiguredBiEntityCondition<?, ?>> entityValidator) {
        return this.perform(entity, new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_()), entity.m_20252_(1.0f), entityValidator);
    }

    @NotNull
    public HitResult perform(@NotNull Entity entity, @NotNull Vec3 origin, @NotNull Vec3 direction, Holder<ConfiguredBiEntityCondition<?, ?>> entityValidator) {
        BlockHitResult blockHit;
        Vec3 target = origin.m_82549_(direction.m_82541_().m_82490_(this.distance()));
        EntityHitResult result = null;
        if (this.entity()) {
            result = this.performEntityRaycast(entity, origin, target, entityValidator);
        }
        if (this.block() && (blockHit = this.performBlockRaycast(entity, origin, target)).m_6662_() != HitResult.Type.MISS && (result == null || result.m_6662_() == HitResult.Type.MISS || result.m_82448_(entity) > blockHit.m_82448_(entity))) {
            result = blockHit;
        }
        if (result == null) {
            return BlockHitResult.m_82426_((Vec3)target, (Direction)Direction.m_122366_((double)direction.f_82479_, (double)direction.f_82480_, (double)direction.f_82481_), (BlockPos)new BlockPos((int)target.m_7096_(), (int)target.m_7098_(), (int)target.m_7094_()));
        }
        return result;
    }

    private BlockHitResult performBlockRaycast(Entity source, Vec3 origin, Vec3 target) {
        ClipContext context = new ClipContext(origin, target, this.shapeType(), this.fluidHandling(), source);
        return source.m_9236_().m_45547_(context);
    }

    private EntityHitResult performEntityRaycast(Entity source, Vec3 origin, Vec3 target, Holder<ConfiguredBiEntityCondition<?, ?>> biEntityCondition) {
        Vec3 ray = target.m_82546_(origin);
        AABB box = source.m_20191_().m_82369_(ray).m_82377_(1.0, 1.0, 1.0);
        return ProjectileUtil.m_37287_((Entity)source, (Vec3)origin, (Vec3)target, (AABB)box, entityx -> !entityx.m_5833_() && ConfiguredBiEntityCondition.check(biEntityCondition, source, entityx), (double)ray.m_82556_());
    }
}

