/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.apoli.command.PowerOperation;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Score;
import net.minecraftforge.common.util.LazyOptional;

public class ResourceCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"resource").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"has").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.HAS)))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.GET)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.SET))))))).then(Commands.m_82127_((String)"change").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.CHANGE))))))).then(Commands.m_82127_((String)"operation").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(Commands.m_82129_((String)"operation", (ArgumentType)PowerOperation.operation()).then(Commands.m_82129_((String)"entity", (ArgumentType)ScoreHolderArgument.m_108217_()).then(Commands.m_82129_((String)"objective", (ArgumentType)ObjectiveArgument.m_101957_()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.OPERATION)))))))));
    }

    private static int extract(OptionalInt optional, CommandContext<CommandSourceStack> command, IntFunction<Component> success, Supplier<Component> failure, boolean flatten) {
        optional.ifPresentOrElse(i -> ((CommandSourceStack)command.getSource()).m_288197_(() -> (Component)success.apply(i), true), () -> ((CommandSourceStack)command.getSource()).m_81352_((Component)failure.get()));
        return flatten ? (optional.isPresent() ? 1 : 0) : optional.orElse(0);
    }

    private static OptionalInt operation(CommandContext<CommandSourceStack> command, ConfiguredPower<?, ?> configuredPower, Entity player) throws CommandSyntaxException {
        Score score = ((CommandSourceStack)command.getSource()).m_81377_().m_129896_().m_83471_(ScoreHolderArgument.m_108223_(command, (String)"entity"), ObjectiveArgument.m_101960_(command, (String)"objective"));
        ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(player, configuredPower, score);
        return configuredPower.getValue(player);
    }

    private static int resource(CommandContext<CommandSourceStack> command, SubCommand sub) throws CommandSyntaxException {
        Supplier<Component> failure;
        Entity player = EntityArgument.m_91452_(command, (String)"target");
        LazyOptional<IPowerContainer> optional = IPowerContainer.get(player);
        ResourceLocation power = (ResourceLocation)command.getArgument("power", ResourceLocation.class);
        ResourceKey<ConfiguredPower<?, ?>> powerKey = PowerTypeArgumentType.getConfiguredPower(command, "power");
        Holder.Reference configuredPower = ApoliAPI.getPowers(((CommandSourceStack)command.getSource()).m_81377_()).m_246971_(powerKey);
        OptionalInt result = switch (sub) {
            default -> throw new IncompatibleClassChangeError();
            case SubCommand.HAS -> optional.map(x -> x.hasPower(power) ? OptionalInt.of(1) : OptionalInt.empty()).orElse(OptionalInt.empty());
            case SubCommand.GET -> ((ConfiguredPower)configuredPower.m_203334_()).getValue(player);
            case SubCommand.SET -> ((ConfiguredPower)configuredPower.m_203334_()).assign(player, IntegerArgumentType.getInteger(command, (String)"value"));
            case SubCommand.CHANGE -> ((ConfiguredPower)configuredPower.m_203334_()).change(player, IntegerArgumentType.getInteger(command, (String)"value"));
            case SubCommand.OPERATION -> ResourceCommand.operation(command, (ConfiguredPower)configuredPower.m_203334_(), player);
        };
        IntFunction<Component> success = switch (sub) {
            default -> throw new IncompatibleClassChangeError();
            case SubCommand.HAS -> i -> Component.m_237115_((String)"commands.execute.conditional.pass");
            case SubCommand.GET -> i -> Component.m_237110_((String)"commands.scoreboard.players.get.success", (Object[])new Object[]{player.m_6302_(), i, power});
            case SubCommand.SET -> i -> Component.m_237110_((String)"commands.scoreboard.players.set.success.single", (Object[])new Object[]{power, player.m_6302_(), i});
            case SubCommand.CHANGE -> i -> Component.m_237110_((String)"commands.scoreboard.players.add.success.single", (Object[])new Object[]{IntegerArgumentType.getInteger((CommandContext)command, (String)"value"), power, player.m_6302_(), i});
            case SubCommand.OPERATION -> i -> Component.m_237110_((String)"commands.scoreboard.players.operation.success.single", (Object[])new Object[]{power, player.m_6302_(), i});
        };
        switch (sub) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case HAS: {
                Supplier<Component> supplier = () -> Component.m_237115_((String)"commands.execute.conditional.fail");
                break;
            }
            case GET: {
                Supplier<Component> supplier = () -> Component.m_237110_((String)"commands.scoreboard.players.get.null", (Object[])new Object[]{power, player.m_6302_()});
                break;
            }
            case SET: 
            case CHANGE: 
            case OPERATION: {
                Supplier<Component> supplier = failure = () -> Component.m_237115_((String)"argument.scoreHolder.empty");
            }
        }
        if (sub == SubCommand.SET || sub == SubCommand.GET || sub == SubCommand.CHANGE) {
            IPowerContainer.sync(player);
        }
        return ResourceCommand.extract(result, command, success, failure, sub != SubCommand.GET);
    }

    public static enum SubCommand {
        HAS,
        GET,
        SET,
        CHANGE,
        OPERATION;

    }
}

