/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Score;

public class PowerOperation
implements ArgumentType<Operation> {
    public static final SimpleCommandExceptionType INVALID_OPERATION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"arguments.operation.invalid"));
    public static final SimpleCommandExceptionType DIVISION_ZERO_EXCEPTION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"arguments.operation.div0"));

    public static PowerOperation operation() {
        return new PowerOperation();
    }

    public Operation parse(StringReader stringReader) throws CommandSyntaxException {
        String stringOperator;
        if (!stringReader.canRead()) {
            throw INVALID_OPERATION.create();
        }
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        return switch (stringOperator = stringReader.getString().substring(i, stringReader.getCursor())) {
            case "=" -> BuiltinOperation.SET;
            case "+=" -> BuiltinOperation.ADD;
            case "-=" -> BuiltinOperation.SUBTRACT;
            case "*=" -> BuiltinOperation.MULTIPLY;
            case "/=" -> BuiltinOperation.DIVIDE;
            case "%=" -> BuiltinOperation.MODULUS;
            case "<" -> BuiltinOperation.MIN;
            case ">" -> BuiltinOperation.MAX;
            case "><" -> BuiltinOperation.SWAP;
            default -> throw INVALID_OPERATION.create();
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82967_((String[])new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, (SuggestionsBuilder)builder);
    }

    private static enum BuiltinOperation implements Operation
    {
        SET((living, power, score) -> power.assign(living, score.m_83400_())),
        ADD((living, power, score) -> power.change(living, score.m_83400_())),
        SUBTRACT((living, power, score) -> power.change(living, -score.m_83400_())),
        MULTIPLY((living, power, score) -> power.getValue(living).ifPresent(current -> power.assign(living, current * score.m_83400_()))),
        DIVIDE((living, power, score) -> {
            int val = score.m_83400_();
            if (val == 0) {
                throw DIVISION_ZERO_EXCEPTION.create();
            }
            power.getValue(living).ifPresent(current -> power.assign(living, Math.floorDiv(current, val)));
        }),
        MODULUS((living, power, score) -> {
            int val = score.m_83400_();
            if (val == 0) {
                throw DIVISION_ZERO_EXCEPTION.create();
            }
            power.getValue(living).ifPresent(current -> power.assign(living, Math.floorMod(current, val)));
        }),
        MIN((living, power, score) -> power.getValue(living).ifPresent(current -> power.assign(living, Math.min(current, score.m_83400_())))),
        MAX((living, power, score) -> power.getValue(living).ifPresent(current -> power.assign(living, Math.min(current, score.m_83400_())))),
        SWAP((living, power, score) -> power.getValue(living).ifPresent(current -> {
            power.assign(living, score.m_83400_());
            score.m_83402_(current);
        }));

        private final Operation operation;

        private BuiltinOperation(Operation operation) {
            this.operation = operation;
        }

        @Override
        public void apply(Entity living, ConfiguredPower<?, ?> power, Score score) throws CommandSyntaxException {
            this.operation.apply(living, power, score);
        }
    }

    public static interface Operation {
        public void apply(Entity var1, ConfiguredPower<?, ?> var2, Score var3) throws CommandSyntaxException;
    }
}

