/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.command.EntityConditionArgument;
import io.github.apace100.apoli.command.PowerSourceArgumentType;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.apace100.apoli.util.JsonTextFormatter;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import joptsimple.internal.Strings;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class PowerCommand {
    public static final ResourceLocation POWER_SOURCE = Apoli.identifier("command");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"power").requires(scs -> scs.m_6761_(2))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(context -> PowerCommand.grantPower((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82129_((String)"source", (ArgumentType)PowerSourceArgumentType.powerSource("targets")).executes(context -> PowerCommand.grantPower((CommandContext<CommandSourceStack>)context, true))))))).then(Commands.m_82127_((String)"revoke").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(context -> PowerCommand.revokePower((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82129_((String)"source", (ArgumentType)PowerSourceArgumentType.powerSource("targets")).executes(context -> PowerCommand.revokePower((CommandContext<CommandSourceStack>)context, true))))))).then(Commands.m_82127_((String)"revokeall").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"source", (ArgumentType)PowerSourceArgumentType.powerSource("targets")).executes(PowerCommand::revokeAllPowers))))).then(Commands.m_82127_((String)"list").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(context -> PowerCommand.listPowers((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82129_((String)"subpowers", (ArgumentType)BoolArgumentType.bool()).executes(context -> PowerCommand.listPowers((CommandContext<CommandSourceStack>)context, true)))))).then(Commands.m_82127_((String)"has").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::hasPower))))).then(Commands.m_82127_((String)"sources").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::getSourcesFromPower))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(PowerCommand::removePower))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(context -> PowerCommand.clearAllPowers((CommandContext<CommandSourceStack>)context, true))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> PowerCommand.clearAllPowers((CommandContext<CommandSourceStack>)context, false))))).then(Commands.m_82127_((String)"dump").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(context -> PowerCommand.dumpPower((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82129_((String)"indent", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> PowerCommand.dumpPower((CommandContext<CommandSourceStack>)context, true)))))).then(Commands.m_82127_((String)"condition").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"condition_json", (ArgumentType)EntityConditionArgument.entityCondition()).executes(PowerCommand::checkCondition)))));
    }

    private static int grantPower(CommandContext<CommandSourceStack> context, boolean isSourceSpecified) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        ResourceKey<ConfiguredPower<?, ?>> power = PowerTypeArgumentType.getConfiguredPower(context, "power");
        ResourceLocation powerSource = isSourceSpecified ? ResourceLocationArgument.m_107011_(context, (String)"source") : Apoli.identifier("command");
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            if (!PowerCommand.grantPower(livingTarget, power, powerSource)) continue;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (isSourceSpecified) {
                if (processedLivingTargets.size() == 1) {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.grant.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), PowerCommand.getPowerName(power, source)}), true);
                } else {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.grant.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), PowerCommand.getPowerName(power, source)}), true);
                }
            } else if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.grant_from_source.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), PowerCommand.getPowerName(power, source), powerSource}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.grant_from_source.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), PowerCommand.getPowerName(power, source), powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.grant.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_(), PowerCommand.getPowerName(power, source), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.grant.fail.multiple", (Object[])new Object[]{livingTargets.size(), PowerCommand.getPowerName(power, source), powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.grant.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_()}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.grant.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return processedLivingTargets.size();
    }

    private static boolean grantPower(LivingEntity entity, ResourceKey<ConfiguredPower<?, ?>> power, ResourceLocation source) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            boolean success = component.addPower(power, source);
            if (success) {
                component.sync();
            }
            return success;
        }).orElse(false);
    }

    private static int revokePower(CommandContext<CommandSourceStack> context, boolean isSourceSpecified) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        ResourceKey<ConfiguredPower<?, ?>> power = PowerTypeArgumentType.getConfiguredPower(context, "power");
        ResourceLocation powerSource = isSourceSpecified ? ResourceLocationArgument.m_107011_(context, (String)"source") : POWER_SOURCE;
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            if (!PowerCommand.hasPower(livingTarget, power, powerSource) || !PowerCommand.revokePower(livingTarget, power, powerSource)) continue;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (!isSourceSpecified) {
                if (processedLivingTargets.size() == 1) {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), PowerCommand.getPowerName(power, source)}), true);
                } else {
                    source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), PowerCommand.getPowerName(power, source)}), true);
                }
            } else if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke_from_source.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), PowerCommand.getPowerName(power, source), powerSource}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke_from_source.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), PowerCommand.getPowerName(power, source), powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_(), PowerCommand.getPowerName(power, source), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke.fail.multiple", (Object[])new Object[]{PowerCommand.getPowerName(power, source), powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_(), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke.invalid_entities", (Object[])new Object[]{nonLivingTargets.size(), powerSource}));
            }
        }
        return processedLivingTargets.size();
    }

    private static boolean revokePower(LivingEntity entity, ResourceKey<ConfiguredPower<?, ?>> power, ResourceLocation source) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            if (component.hasPower(power, source)) {
                component.removePower(power, source);
                component.sync();
                return true;
            }
            return false;
        }).orElse(false);
    }

    private static int revokeAllPowers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        ResourceLocation powerSource = ResourceLocationArgument.m_107011_(context, (String)"source");
        int revokedPowers = 0;
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            int i = PowerCommand.revokeAllPowersFromSource(livingTarget, powerSource);
            if (i == 0) continue;
            revokedPowers += i;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            int currentRevokedPowers = revokedPowers;
            if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke_all.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), currentRevokedPowers, powerSource}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.revoke_all.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), currentRevokedPowers, powerSource}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke_all.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_(), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke_all.fail.multiple", (Object[])new Object[]{powerSource}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke_all.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_(), powerSource}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.revoke_all.invalid_entities", (Object[])new Object[]{nonLivingTargets.size(), powerSource}));
            }
        }
        return processedLivingTargets.size();
    }

    private static int revokeAllPowersFromSource(LivingEntity entity, ResourceLocation source) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            int i = component.removeAllPowersFromSource(source);
            if (i > 0) {
                component.sync();
            }
            return i;
        }).orElse(0);
    }

    private static int listPowers(CommandContext<CommandSourceStack> context, boolean includeSubpowers) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity target = EntityArgument.m_91452_(context, (String)"target");
        LinkedList<MutableComponent> powers = new LinkedList<MutableComponent>();
        int powerCount = 0;
        if (!(target instanceof LivingEntity)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.list.fail", (Object[])new Object[]{target.m_5446_()}));
            return powerCount;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        IPowerContainer component = ApoliAPI.getPowerContainer((Entity)livingTarget);
        if (component == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.list.fail", (Object[])new Object[]{target.m_5446_()}));
            return powerCount;
        }
        for (ResourceKey<ConfiguredPower<?, ?>> power : component.getPowerTypes(includeSubpowers)) {
            LinkedList sourcesTooltip = new LinkedList();
            component.getSources(power).forEach(id -> sourcesTooltip.add(Component.m_237113_((String)id.toString())));
            HoverEvent sourceHoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"commands.apoli.list.sources", (Object[])new Object[]{ComponentUtils.m_178433_(sourcesTooltip, (Component)Component.m_237113_((String)","))}));
            MutableComponent powerTooltip = Component.m_237113_((String)power.m_135782_().toString()).m_6270_(Style.f_131099_.m_131144_(sourceHoverEvent));
            powers.add(powerTooltip);
            ++powerCount;
        }
        if (powerCount == 0) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.list.fail", (Object[])new Object[]{target.m_7755_()}));
        } else {
            int finalPowerCount = powerCount;
            source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.list.pass", (Object[])new Object[]{target.m_7755_(), finalPowerCount, ComponentUtils.m_178433_((Collection)powers, (Component)Component.m_237113_((String)", "))}), true);
        }
        return powerCount;
    }

    private static int hasPower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        ResourceKey<ConfiguredPower<?, ?>> power = PowerTypeArgumentType.getConfiguredPower(context, "power");
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            LivingEntity livingTarget;
            if (!(target instanceof LivingEntity) || !PowerCommand.hasPower(livingTarget = (LivingEntity)target, power)) continue;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237115_((String)"commands.execute.conditional.pass"), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.execute.conditional.pass_count", (Object[])new Object[]{processedLivingTargets.size()}), true);
            }
        } else if (targets.size() == 1) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.execute.conditional.fail"));
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"commands.execute.conditional.fail_count", (Object[])new Object[]{targets.size()}));
        }
        return processedLivingTargets.size();
    }

    private static boolean hasPower(LivingEntity entity, ResourceKey<ConfiguredPower<?, ?>> power) {
        return IPowerContainer.get((Entity)entity).map(x -> x.hasPower(power)).orElse(false);
    }

    private static boolean hasPower(LivingEntity entity, ResourceKey<ConfiguredPower<?, ?>> power, ResourceLocation powerSource) {
        return IPowerContainer.get((Entity)entity).map(x -> x.hasPower(power, powerSource)).orElse(false);
    }

    private static int getSourcesFromPower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity target = EntityArgument.m_91452_(context, (String)"target");
        ResourceKey<ConfiguredPower<?, ?>> power = PowerTypeArgumentType.getConfiguredPower(context, "power");
        Component powerName = PowerCommand.getPowerName(power, source);
        StringBuilder powerSources = new StringBuilder();
        int powerSourceCount = 0;
        if (!(target instanceof LivingEntity)) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.sources.fail", (Object[])new Object[]{target.m_5446_(), powerName}));
            return powerSourceCount;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        IPowerContainer component = ApoliAPI.getPowerContainer((Entity)livingTarget);
        if (component != null) {
            String separator = "";
            for (ResourceLocation powerSource : component.getSources(power)) {
                powerSources.append(separator).append(powerSource.toString());
                ++powerSourceCount;
                separator = ", ";
            }
        }
        if (powerSourceCount == 0) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.sources.fail", (Object[])new Object[]{target.m_7755_(), powerName}));
        } else {
            int finalPowers = powerSourceCount;
            source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.sources.pass", (Object[])new Object[]{target.m_7755_(), finalPowers, powerName, powerSources}), true);
        }
        return powerSourceCount;
    }

    private static int removePower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        ResourceKey<ConfiguredPower<?, ?>> power = PowerTypeArgumentType.getConfiguredPower(context, "power");
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            IPowerContainer component = ApoliAPI.getPowerContainer((Entity)livingTarget);
            if (component == null || !PowerCommand.revokePowerAllSources(livingTarget, power)) continue;
            processedLivingTargets.add(livingTarget);
        }
        Component powerName = PowerCommand.getPowerName(power, source);
        if (!processedLivingTargets.isEmpty()) {
            if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.remove.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), powerName}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.remove.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), powerName}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.remove.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_(), powerName}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.remove.fail.multiple", (Object[])new Object[]{powerName}));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.remove.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_()}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.remove.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return processedLivingTargets.size();
    }

    private static boolean revokePowerAllSources(LivingEntity entity, ResourceKey<ConfiguredPower<?, ?>> power) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            List<ResourceLocation> sources = component.getSources(power);
            if (sources.isEmpty()) {
                return false;
            }
            for (ResourceLocation source : sources) {
                component.removePower(power, source);
            }
            if (sources.size() > 0) {
                component.sync();
            }
            return true;
        }).orElse(false);
    }

    private static int clearAllPowers(CommandContext<CommandSourceStack> context, boolean onlyTargetSelf) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        LinkedList<Entity> nonLivingTargets = new LinkedList<Entity>();
        LinkedList<LivingEntity> livingTargets = new LinkedList<LivingEntity>();
        LinkedList<LivingEntity> processedLivingTargets = new LinkedList<LivingEntity>();
        int clearedPowers = 0;
        for (Entity target : targets) {
            if (!(target instanceof LivingEntity)) {
                nonLivingTargets.add(target);
                continue;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            livingTargets.add(livingTarget);
            int cleared = PowerCommand.clearAllPowers(livingTarget);
            if (cleared == 0) continue;
            clearedPowers += cleared;
            processedLivingTargets.add(livingTarget);
        }
        if (!processedLivingTargets.isEmpty()) {
            int currentClearedPowers = clearedPowers;
            if (processedLivingTargets.size() == 1) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.clear.success.single", (Object[])new Object[]{((LivingEntity)processedLivingTargets.getFirst()).m_5446_(), currentClearedPowers}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.apoli.clear.success.multiple", (Object[])new Object[]{processedLivingTargets.size(), currentClearedPowers}), true);
            }
        } else if (!livingTargets.isEmpty()) {
            if (livingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.clear.fail.single", (Object[])new Object[]{((LivingEntity)livingTargets.getFirst()).m_5446_()}));
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"commands.apoli.clear.fail.multiple"));
            }
        } else if (!nonLivingTargets.isEmpty()) {
            if (nonLivingTargets.size() == 1) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.clear.invalid_entity", (Object[])new Object[]{((Entity)nonLivingTargets.getFirst()).m_5446_()}));
            } else {
                source.m_81352_((Component)Component.m_237110_((String)"commands.apoli.clear.invalid_entities", (Object[])new Object[]{nonLivingTargets.size()}));
            }
        }
        return clearedPowers;
    }

    private static int clearAllPowers(LivingEntity entity) {
        return IPowerContainer.get((Entity)entity).map(component -> {
            @NotNull Set<ResourceKey<ConfiguredPower<?, ?>>> powers = component.getPowerTypes(false);
            for (ResourceKey<ConfiguredPower<?, ?>> power : powers) {
                PowerCommand.revokePowerAllSources(entity, power);
            }
            if (powers.size() > 0) {
                component.sync();
            }
            return powers.size();
        }).orElse(0);
    }

    public static Component getPowerName(ResourceKey<ConfiguredPower<?, ?>> power, CommandSourceStack source) {
        return ((ConfiguredPower)ApoliAPI.getPowers(source.m_81377_()).m_6246_(power)).getData().getName();
    }

    public static int dumpPower(CommandContext<CommandSourceStack> context, boolean indentSpecified) {
        ResourceKey<ConfiguredPower<?, ?>> arg = PowerTypeArgumentType.getConfiguredPower(context, "power");
        ConfiguredPower power = (ConfiguredPower)ApoliAPI.getPowers(((CommandSourceStack)context.getSource()).m_81377_()).m_246971_(arg).m_203334_();
        String indent = Strings.repeat((char)' ', (int)(indentSpecified ? IntegerArgumentType.getInteger(context, (String)"indent") : 4));
        Component s = (Component)ConfiguredPower.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)power).map(jsonElement -> new JsonTextFormatter(indent).apply((JsonElement)jsonElement)).result().orElseThrow(() -> new CommandRuntimeException((Component)Component.m_237113_((String)("Failed to encode " + arg))));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> s, false);
        return 1;
    }

    public static int checkCondition(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity target = EntityArgument.m_91452_(context, (String)"target");
        ConfiguredEntityCondition<?, ?> condition = EntityConditionArgument.getEntityCondition(context, "condition_json");
        if (condition.check(target)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.execute.conditional.pass"), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.execute.conditional.fail"), false);
        return 0;
    }
}

