/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.action.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;

public final class ExplodeConfiguration
implements IDynamicFeatureConfiguration {
    public static final Codec<ExplodeConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CalioCodecHelper.FLOAT.fieldOf("power").forGetter(ExplodeConfiguration::power), (App)CalioCodecHelper.optionalField(ApoliDataTypes.BACKWARDS_COMPATIBLE_DESTRUCTION_TYPE, (String)"destruction_type", (Object)Explosion.BlockInteraction.DESTROY).forGetter(ExplodeConfiguration::destructionType), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"damage_self", (Object)true).forGetter(ExplodeConfiguration::damageSelf), (App)ConfiguredBlockCondition.optional("indestructible", Apoli.identifier("deny")).forGetter(ExplodeConfiguration::indestructible), (App)ConfiguredBlockCondition.optional("destructible", Apoli.identifier("deny")).forGetter(ExplodeConfiguration::destructible), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"create_fire", (Object)false).forGetter(ExplodeConfiguration::createFire)).apply((Applicative)instance, ExplodeConfiguration::new));
    private final float power;
    private final Explosion.BlockInteraction destructionType;
    private final boolean damageSelf;
    private final Holder<ConfiguredBlockCondition<?, ?>> indestructible;
    private final Holder<ConfiguredBlockCondition<?, ?>> destructible;
    private final boolean createFire;
    private final transient Lazy<ExplosionDamageCalculator> explosionCalculator;

    public ExplodeConfiguration(float power, Explosion.BlockInteraction destructionType, boolean damageSelf, Holder<ConfiguredBlockCondition<?, ?>> indestructible, Holder<ConfiguredBlockCondition<?, ?>> destructible, boolean createFire) {
        this.power = power;
        this.destructionType = destructionType;
        this.damageSelf = damageSelf;
        this.indestructible = indestructible;
        this.destructible = destructible;
        this.createFire = createFire;
        this.explosionCalculator = Lazy.of(() -> !this.indestructible().m_203633_() || !this.destructible().m_203633_() ? new ExplosionDamageCalculator() : new ExplosionDamageCalculator(){

            @NotNull
            public Optional<Float> m_6617_(@NotNull Explosion explosion, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluid) {
                Optional ovr;
                Optional def = super.m_6617_(explosion, world, pos, state, fluid);
                Optional<Object> optional = ovr = ConfiguredBlockCondition.check(ExplodeConfiguration.this.indestructible(), (LevelReader)world, pos, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> state)) && (!ExplodeConfiguration.this.destructible().m_203633_() || !ConfiguredBlockCondition.check(ExplodeConfiguration.this.destructible(), (LevelReader)world, pos, (NonNullSupplier<BlockState>)((NonNullSupplier)() -> state))) ? Optional.of(Float.valueOf(100.0f)) : Optional.empty();
                return ovr.isPresent() ? (def.isPresent() ? (((Float)def.get()).floatValue() > ((Float)ovr.get()).floatValue() ? def : ovr) : ovr) : def;
            }
        });
    }

    public float power() {
        return this.power;
    }

    public Explosion.BlockInteraction destructionType() {
        return this.destructionType;
    }

    public boolean damageSelf() {
        return this.damageSelf;
    }

    public Holder<ConfiguredBlockCondition<?, ?>> indestructible() {
        return this.indestructible;
    }

    public Holder<ConfiguredBlockCondition<?, ?>> destructible() {
        return this.destructible;
    }

    public boolean createFire() {
        return this.createFire;
    }

    @NotNull
    public ExplosionDamageCalculator calculator() {
        return (ExplosionDamageCalculator)this.explosionCalculator.get();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ExplodeConfiguration that = (ExplodeConfiguration)obj;
        return Float.floatToIntBits(this.power) == Float.floatToIntBits(that.power) && Objects.equals(this.destructionType, that.destructionType) && this.damageSelf == that.damageSelf && Objects.equals(this.indestructible, that.indestructible) && Objects.equals(this.destructible, that.destructible) && this.createFire == that.createFire;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.power), this.destructionType, this.damageSelf, this.indestructible, this.destructible, this.createFire);
    }

    public String toString() {
        return "ExplodeConfiguration[power=" + this.power + ", destructionType=" + this.destructionType + ", damageSelf=" + this.damageSelf + ", indestructible=" + this.indestructible + ", destructible=" + this.destructible + ", createFire=" + this.createFire + "]";
    }
}

