/*
 * Decompiled with CFR 0.152.
 */
package dev.experiment.hud.factory;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.experiment.hud.ConfiguredHudRenderer;
import dev.experiment.hud.DrawType;
import dev.experiment.hud.HudRendererFactory;
import io.github.apace100.apoli.util.HudRender;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DefaultHudRenderer
extends HudRendererFactory<HudRender> {
    public DefaultHudRenderer() {
        super(HudRender.CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBar(ConfiguredHudRenderer<HudRender, ?> renderer, Entity player, GuiGraphics graphics, int x, int y, int width, float fill) {
        HudRender render = (HudRender)renderer.getConfiguration();
        ResourceLocation currentLocation = render.spriteLocation();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)currentLocation);
        int v = 8 + render.barIndex() * 10;
        if (render.isInverted()) {
            fill = 1.0f - fill;
        }
        int w = (int)(fill * (float)width);
        graphics.m_280398_(currentLocation, x, y, 0, 0.0f, 0.0f, width, 5, 256, 256);
        graphics.m_280398_(currentLocation, x, y, 0, 0.0f, (float)v, w, 8, 256, 256);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawIcon(ConfiguredHudRenderer<HudRender, ?> renderer, Entity player, GuiGraphics graphics, int x, int y, float fill) {
        HudRender render = (HudRender)renderer.getConfiguration();
        int v = 8 + render.barIndex() * 10;
        graphics.m_280398_(render.spriteLocation(), x, y, 1, 73.0f, (float)v, 8, 8, 256, 256);
    }

    @Override
    public DrawType shouldDraw(ConfiguredHudRenderer<HudRender, ?> renderer, Entity player) {
        return ((HudRender)renderer.getConfiguration()).shouldRender(player) ? DrawType.SHOW : DrawType.HIDE;
    }

    @Override
    public int height(ConfiguredHudRenderer<HudRender, ?> renderer, Entity player) {
        return 8;
    }

    @Override
    public HudRender asStable(ConfiguredHudRenderer<HudRender, ?> renderer) {
        return (HudRender)renderer.getConfiguration();
    }
}

