/*
 * Decompiled with CFR 0.152.
 */
package dev.experiment.hud;

import com.mojang.serialization.Codec;
import dev.experiment.helper.ExperimentCodec;
import dev.experiment.hud.DrawType;
import dev.experiment.hud.HudExperiment;
import dev.experiment.hud.HudRendererFactory;
import dev.experiment.hud.factory.DefaultHudRenderer;
import io.github.apace100.apoli.util.HudRender;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.ConfiguredFactory;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ConfiguredHudRenderer<T extends IDynamicFeatureConfiguration, F extends HudRendererFactory<T>>
extends ConfiguredFactory<T, F, ConfiguredHudRenderer<T, F>> {
    public static final Codec<ConfiguredHudRenderer<?, ?>> BASE_CODEC = HudRendererFactory.CODEC.dispatch(ConfiguredFactory::getFactory, HudRendererFactory::getCodec);
    public static final Codec<ConfiguredHudRenderer<?, ?>> LEGACY_CODEC = HudRender.MAP_CODEC.xmap(render -> ((DefaultHudRenderer)HudExperiment.DEFAULT.get()).configure((IDynamicFeatureConfiguration)render), ConfiguredHudRenderer::asStable).codec();
    public static final Codec<ConfiguredHudRenderer<?, ?>> CODEC = new ExperimentCodec(LEGACY_CODEC, BASE_CODEC, HudExperiment::isEnabled);

    public ConfiguredHudRenderer(Supplier<F> factory, T configuration) {
        super(factory, configuration);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBar(Entity player, GuiGraphics graphics, int x, int y, int width, float fill) {
        ((HudRendererFactory)this.getFactory()).drawBar(this, player, graphics, x, y, width, fill);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawIcon(Entity player, GuiGraphics graphics, int x, int y, float fill) {
        ((HudRendererFactory)this.getFactory()).drawIcon(this, player, graphics, x, y, fill);
    }

    public DrawType shouldDraw(Entity player) {
        return ((HudRendererFactory)this.getFactory()).shouldDraw(this, player);
    }

    public int height(Entity player) {
        return ((HudRendererFactory)this.getFactory()).height(this, player);
    }

    public HudRender asStable() {
        return ((HudRendererFactory)this.getFactory()).asStable(this);
    }
}

