/*
 * Decompiled with CFR 0.152.
 */
package dev.experiment.hud;

import dev.experiment.hud.ConfiguredHudRenderer;
import dev.experiment.hud.DrawType;
import io.github.apace100.apoli.screen.GameHudRender;
import io.github.apace100.apoli.util.ApoliConfigs;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidType;

@OnlyIn(value=Dist.CLIENT)
public enum ConfiguredHudDrawer implements GameHudRender
{
    INSTANCE;

    private static final int BAR_WIDTH = 71;

    @Override
    public void render(GuiGraphics matrixStack, float tickDelta) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        LazyOptional<IPowerContainer> containerOptional = IPowerContainer.get((Entity)player);
        if (!containerOptional.isPresent() || player == null) {
            return;
        }
        IPowerContainer container = (IPowerContainer)containerOptional.orElseThrow(RuntimeException::new);
        int x = client.m_91268_().m_85445_() / 2 + 20 + (Integer)ApoliConfigs.CLIENT.resourcesAndCooldowns.hudOffsetX.get();
        int y = client.m_91268_().m_85446_() - 47 + (Integer)ApoliConfigs.CLIENT.resourcesAndCooldowns.hudOffsetY.get();
        Entity entity = player.m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity;
            y -= 8 * (int)(vehicle.m_21233_() / 20.0f);
        }
        if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) || player.m_20146_() < player.m_6062_()) {
            y -= 8;
        }
        for (Holder<ConfiguredPower<?, ?>> power : container.getPowers()) {
            if (!power.m_203633_()) {
                return;
            }
            ConfiguredHudRenderer renderer = null;
            DrawType drawType = renderer.shouldDraw((Entity)player);
            if (!((ConfiguredPower)power.m_203334_()).shouldRender((Entity)player).map(drawType).orElse(false).booleanValue()) continue;
            int height = renderer.height((Entity)player);
            float fill = ((ConfiguredPower)power.m_203334_()).getFill((Entity)player).orElse(Float.valueOf(0.0f)).floatValue();
            renderer.drawBar((Entity)player, matrixStack, x - 2, y - height + 6, 71, fill);
            renderer.drawIcon((Entity)player, matrixStack, x - height - 2, y - height + 6, fill);
            y -= height;
        }
    }
}

