/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.modifier;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class DemolishingModifierBlockBreaker {
    private static final Map<UUID, DemolishingModifierBlockBreaker> ACTIVE_BREAKERS = new HashMap<UUID, DemolishingModifierBlockBreaker>();
    private static final Map<UUID, DemolishingModifierBlockBreaker> ACTIVE_CLIENT_BREAKERS = new HashMap<UUID, DemolishingModifierBlockBreaker>();
    private final Level level;
    private final BlockPos pos;
    private final BlockState state;
    private final Player player;
    private final Map<BlockPos, Integer> idFromPos;

    private DemolishingModifierBlockBreaker(Level level, BlockPos pos, BlockState state, Player player, List<BlockPos> positions) {
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.player = player;
        this.idFromPos = positions.stream().collect(Collectors.toMap(Function.identity(), offsetPos -> player.m_217043_().m_188503_(5000)));
    }

    public static DemolishingModifierBlockBreaker getOrCreate(Level level, BlockPos pos, BlockState state, Player player) {
        boolean createBreaker;
        UUID uuid = player.m_20148_();
        boolean bl = createBreaker = !DemolishingModifierBlockBreaker.containsBreaker(level, uuid);
        if (!createBreaker && !DemolishingModifierBlockBreaker.getBreaker(level, uuid).getPos().equals((Object)pos)) {
            createBreaker = true;
            DemolishingModifierBlockBreaker.getBreaker(level, uuid).stop();
        }
        if (createBreaker) {
            DemolishingModifierBlockBreaker.create(level, pos, state, player);
        }
        return DemolishingModifierBlockBreaker.getBreaker(level, uuid);
    }

    private static void create(Level level, BlockPos pos, BlockState state, Player player) {
        List<BlockPos> positions = new BlockScanner(pos).getValidPositions(level, DemolishingModifierBlockBreaker.calculateBlockSide(level, player), offsetState -> offsetState.m_60713_(state.m_60734_()));
        DemolishingModifierBlockBreaker.putBreaker(level, player.m_20148_(), new DemolishingModifierBlockBreaker(level, pos, state, player, positions));
    }

    private static Direction calculateBlockSide(Level level, Player player) {
        Vec3 eyePosition = player.m_146892_();
        Vec3 viewVector = player.m_20252_(1.0f);
        double reach = player.m_246858_((Holder)ForgeMod.BLOCK_REACH.getHolder().orElseThrow());
        Vec3 combined = eyePosition.m_82520_(viewVector.f_82479_ * reach, viewVector.f_82480_ * reach, viewVector.f_82481_ * reach);
        BlockHitResult hitResult = level.m_45547_(new ClipContext(eyePosition, combined, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return Direction.NORTH;
        }
        return hitResult.m_82434_();
    }

    private static DemolishingModifierBlockBreaker getBreaker(Level level, UUID uuid) {
        if (level.m_5776_()) {
            return ACTIVE_CLIENT_BREAKERS.getOrDefault(uuid, null);
        }
        return ACTIVE_BREAKERS.getOrDefault(uuid, null);
    }

    private static boolean containsBreaker(Level level, UUID uuid) {
        if (level.m_5776_()) {
            return ACTIVE_CLIENT_BREAKERS.containsKey(uuid);
        }
        return ACTIVE_BREAKERS.containsKey(uuid);
    }

    private static void putBreaker(Level level, UUID uuid, DemolishingModifierBlockBreaker breaker) {
        if (level.m_5776_()) {
            ACTIVE_CLIENT_BREAKERS.put(uuid, breaker);
            return;
        }
        ACTIVE_BREAKERS.put(uuid, breaker);
    }

    private static void removeBreaker(Level level, UUID uuid) {
        if (level.m_5776_()) {
            ACTIVE_CLIENT_BREAKERS.remove(uuid);
            return;
        }
        ACTIVE_BREAKERS.remove(uuid);
    }

    public static Optional<DemolishingModifierBlockBreaker> get(Level level, Player player) {
        return Optional.ofNullable(DemolishingModifierBlockBreaker.getBreaker(level, player.m_20148_()));
    }

    public void update(int destroyProgress) {
        if (!this.checkPositions()) {
            return;
        }
        for (BlockPos offsetPos : this.idFromPos.keySet()) {
            if (destroyProgress >= 10) {
                return;
            }
            this.updateBreakingProgress(offsetPos, destroyProgress - 1);
        }
    }

    private boolean checkPositions() {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.idFromPos.entrySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next().getKey();
            if (this.level.m_8055_(pos).m_60713_(this.state.m_60734_())) continue;
            iterator.remove();
        }
        if (this.idFromPos.isEmpty()) {
            this.stop();
            return false;
        }
        return true;
    }

    public void stop() {
        this.idFromPos.forEach((offsetPos, integer) -> this.updateBreakingProgress((BlockPos)offsetPos, -1));
        DemolishingModifierBlockBreaker.removeBreaker(this.level, this.player.m_20148_());
    }

    public void breakBlocks(ServerPlayer player) {
        this.stop();
        this.idFromPos.keySet().forEach(arg_0 -> ((ServerPlayerGameMode)player.f_8941_).m_9280_(arg_0));
    }

    private void updateBreakingProgress(BlockPos pos, int progress) {
        int id = this.idFromPos.get(pos);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer serverPlayer : serverLevel.m_7654_().m_6846_().m_11314_()) {
                double d2;
                double d1;
                double d0;
                if (serverPlayer == null || serverPlayer.m_9236_() != serverLevel || serverPlayer.m_19879_() == this.player.m_19879_() || !((d0 = (double)pos.m_123341_() - serverPlayer.m_20185_()) * d0 + (d1 = (double)pos.m_123342_() - serverPlayer.m_20186_()) * d1 + (d2 = (double)pos.m_123343_() - serverPlayer.m_20189_()) * d2 < 1024.0)) continue;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundBlockDestructionPacket(id, pos, progress));
            }
            return;
        }
        this.level.m_6801_(id, pos, progress);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    private record BlockScanner(BlockPos centerPos) {
        private List<BlockPos> getValidPositions(Level level, Direction facing, Predicate<BlockState> predicate) {
            int data3d = facing.m_122411_();
            Pair<BlockPos, BlockPos> cornerPositions = this.getCornerPositions(Direction.m_122376_((int)(data3d + 2)), Direction.m_122376_((int)(data3d + 4)));
            return BlockPos.m_121990_((BlockPos)((BlockPos)cornerPositions.getFirst()), (BlockPos)((BlockPos)cornerPositions.getSecond())).filter(pos -> predicate.test(level.m_8055_(pos))).filter(pos -> !pos.equals((Object)this.centerPos)).map(BlockPos::m_7949_).toList();
        }

        private Pair<BlockPos, BlockPos> getCornerPositions(Direction first, Direction second) {
            return Pair.of((Object)this.centerPos.m_5484_(first, 1).m_5484_(second, 1), (Object)this.centerPos.m_5484_(first, -1).m_5484_(second, -1));
        }
    }
}

