/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.jadecolonies.minecolonies;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

class BuildingNameComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    private static final ResourceLocation UID = new ResourceLocation("jadecolonies", "colony.hut");
    private static final String OVERRIDE_NAME = "givenName";
    private static final String BUILDING_NAME = UID.toString();
    private static final BuildingNameComponentProvider INSTANCE = new BuildingNameComponentProvider();

    BuildingNameComponentProvider() {
    }

    public static BuildingNameComponentProvider getInstance() {
        return INSTANCE;
    }

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    public boolean isRequired() {
        return true;
    }

    public int getDefaultPriority() {
        return -3000;
    }

    public void appendServerData(@NotNull CompoundTag compoundTag, @NotNull BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding entity = (AbstractTileEntityColonyBuilding)blockEntity;
            IBuilding building = entity.getBuilding();
            if (building == null || building instanceof IRSComponent) {
                return;
            }
            String name = building.getCustomName();
            MutableComponent nameLevel = Component.m_237110_((String)"%s %s", (Object[])new Object[]{Component.m_237115_((String)building.getBuildingType().getTranslationKey()), Integer.toString(building.getBuildingLevel())});
            if (name.isEmpty()) {
                compoundTag.m_128359_(OVERRIDE_NAME, Component.Serializer.m_130703_((Component)nameLevel));
            } else {
                compoundTag.m_128359_(OVERRIDE_NAME, Component.Serializer.m_130703_((Component)Component.m_237113_((String)name)));
                compoundTag.m_128359_(BUILDING_NAME, Component.Serializer.m_130703_((Component)nameLevel.m_130940_(ChatFormatting.GRAY)));
            }
        } else {
            blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof TileEntityDecorationController) {
                TileEntityDecorationController deco = (TileEntityDecorationController)blockEntity;
                compoundTag.m_128359_(BUILDING_NAME, Component.Serializer.m_130703_((Component)Component.m_237113_((String)deco.getBlueprintPath())));
            }
        }
    }

    public void appendTooltip(@NotNull ITooltip tooltip, @NotNull BlockAccessor blockAccessor, @NotNull IPluginConfig pluginConfig) {
        CompoundTag data = blockAccessor.getServerData();
        if (data.m_128441_(BUILDING_NAME)) {
            MutableComponent name = Component.Serializer.m_130701_((String)data.m_128461_(BUILDING_NAME));
            tooltip.add((Component)name);
        }
    }
}

