/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.chunk;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import com.betterchunkloading.event.EventHandler;
import com.betterchunkloading.event.ITickingTask;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerChunkData {
    private static final ChunkPos INVALID = new ChunkPos(0, 0){

        public boolean equals(Object other) {
            return other == INVALID;
        }
    };
    private final TicketType<ChunkPos> chunkloadTicketType;
    private final TicketType<ChunkPos> predictionTicketType;
    private ChunkPos lastChunk = INVALID;
    private ResourceKey<Level> lastLevel = null;
    private ChunkLoadingTask viewDistLoadTask = null;
    private int playerChunkLoadViewDistance = 0;
    ChunkLoadingTask predictionTask = null;
    private BlockPos[] playerMovementTracker = new BlockPos[6];
    private int playerMovementTrackerIndex = 0;
    private long lastPlayerMovementUpdate = 0L;
    private BlockPos lastPlayerPos = null;
    private double playerMovementSpeed = 0.0;
    private Vec3 direction = Vec3.f_82478_;
    private static Long2ObjectOpenHashMap<Set<Ticket>> expiringTicketsMap = new Long2ObjectOpenHashMap();

    public PlayerChunkData(ServerPlayer player) {
        this.chunkloadTicketType = TicketType.m_9465_((String)("bcl_player_" + player.m_7755_().getString()), Comparator.comparingLong(ChunkPos::m_45588_), (int)24000);
        this.predictionTicketType = TicketType.m_9465_((String)("bcl_pred_player_" + player.m_7755_().getString()), Comparator.comparingLong(ChunkPos::m_45588_), (int)1200);
    }

    public void onChunkChanged(ServerPlayer player, ChunkPos chunkPos) {
        if (player == null || player.getClass() != ServerPlayer.class) {
            return;
        }
        if (chunkPos == null) {
            chunkPos = player.m_146902_();
        }
        if (!player.m_9236_().m_46472_().equals(this.lastLevel)) {
            if (this.lastLevel != null && this.predictionTask != null) {
                this.predictionTask.cancel();
                this.predictionTask = null;
            }
            this.updatePlayerViewDistance(chunkPos, (ServerChunkCache)player.m_9236_().m_7726_(), 4, this.chunkloadTicketType);
            this.playerChunkLoadViewDistance = 4;
            this.playerMovementTracker = new BlockPos[6];
            this.playerMovementTrackerIndex = 0;
            this.lastPlayerMovementUpdate = 0L;
            this.lastPlayerPos = null;
            this.playerMovementSpeed = 0.0;
            this.direction = Vec3.f_82478_;
            this.lastLevel = player.m_9236_().m_46472_();
            this.lastChunk = null;
            return;
        }
        if (this.lastChunk != null && chunkPos.m_45594_(this.lastChunk) > 10) {
            this.playerMovementTracker = new BlockPos[6];
            this.playerMovementTrackerIndex = 0;
            this.lastPlayerMovementUpdate = 0L;
            this.lastPlayerPos = null;
            this.playerMovementSpeed = 0.0;
            this.direction = Vec3.f_82478_;
            if (this.predictionTask != null) {
                this.predictionTask.cancel();
                this.predictionTask = null;
            }
            this.updatePlayerViewDistance(chunkPos, (ServerChunkCache)player.m_9236_().m_7726_(), 4, this.chunkloadTicketType);
            this.lastLevel = player.m_9236_().m_46472_();
            this.lastChunk = null;
            return;
        }
        if (chunkPos.equals((Object)this.lastChunk)) {
            if (System.currentTimeMillis() - this.lastPlayerMovementUpdate > 5000L) {
                this.trackPlayerMovement(player);
            }
            return;
        }
        this.trackPlayerMovement(player);
        this.lastChunk = chunkPos;
    }

    private void trackPlayerMovement(ServerPlayer player) {
        long currentTime = System.currentTimeMillis();
        if (this.lastPlayerPos != null) {
            this.playerMovementSpeed -= this.playerMovementSpeed / 5.0;
            int x = player.m_146903_() - this.lastPlayerPos.m_123341_();
            int z = player.m_146907_() - this.lastPlayerPos.m_123343_();
            this.playerMovementSpeed += Math.sqrt(x * x + z * z) / ((double)(currentTime - this.lastPlayerMovementUpdate) / 1000.0) / 5.0;
        }
        this.lastPlayerPos = player.m_20183_();
        this.lastPlayerMovementUpdate = currentTime;
        if (!player.m_146902_().equals((Object)this.lastChunk)) {
            this.playerMovementTrackerIndex = (this.playerMovementTrackerIndex + 1) % this.playerMovementTracker.length;
            this.playerMovementTracker[this.playerMovementTrackerIndex] = player.m_20183_();
            this.checkDirection(player);
        }
        this.doChunkLoadForPlayer(player, this.lastChunk);
    }

    private Vec3 calculatePlayerMovementVec() {
        int xOld = 0;
        int zOld = 0;
        int oldCounter = 0;
        int xNew = 0;
        int zNew = 0;
        int newCounter = 0;
        for (int i = 0; i < this.playerMovementTracker.length; ++i) {
            BlockPos pos = this.playerMovementTracker[(this.playerMovementTrackerIndex + 1 + i) % this.playerMovementTracker.length];
            if (pos == null) continue;
            if (i < this.playerMovementTracker.length / 2) {
                xOld += pos.m_123341_();
                zOld += pos.m_123343_();
                ++oldCounter;
                continue;
            }
            xNew += pos.m_123341_();
            zNew += pos.m_123343_();
            ++newCounter;
        }
        if (oldCounter == 0 || newCounter == 0) {
            return new Vec3(48.0, 0.0, 0.0);
        }
        return new Vec3((double)((xNew /= newCounter) - (xOld /= oldCounter)), 0.0, (double)((zNew /= newCounter) - (zOld /= oldCounter)));
    }

    private void doChunkLoadForPlayer(ServerPlayer player, ChunkPos lastChunk) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading) {
            return;
        }
        int viewDistance = ((ServerChunkCache)player.m_9236_().m_7726_()).f_8325_.f_140126_;
        if (player.m_146902_().equals((Object)lastChunk) && viewDistance == this.playerChunkLoadViewDistance) {
            return;
        }
        this.updatePlayerViewDistance(player.m_146902_(), ((ServerLevel)player.m_9236_()).m_7726_(), viewDistance, this.chunkloadTicketType);
    }

    private void updatePlayerViewDistance(ChunkPos pos, ServerChunkCache chunkSource, int viewDistance, TicketType ticketType) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading) {
            return;
        }
        if (pos == null) {
            if (this.viewDistLoadTask != null) {
                this.viewDistLoadTask.cancel();
            }
            this.viewDistLoadTask = null;
            return;
        }
        this.playerChunkLoadViewDistance = viewDistance;
        ChunkPos predictionPos = new ChunkPos(pos.f_45578_ + (int)this.direction.m_82541_().m_82542_((double)3.0, (double)3.0, (double)3.0).f_82479_, pos.f_45579_ + (int)this.direction.m_82541_().m_82542_((double)3.0, (double)3.0, (double)3.0).f_82481_);
        ArrayList<ChunkTicketPos> toLoad = new ArrayList<ChunkTicketPos>();
        for (int x = pos.f_45578_ - viewDistance; x < pos.f_45578_ + viewDistance; ++x) {
            for (int z = pos.f_45579_ - viewDistance; z < pos.f_45579_ + viewDistance; ++z) {
                int xDiff = pos.f_45578_ - x;
                int zDiff = pos.f_45579_ - z;
                double distance = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                if (!(distance < (double)viewDistance)) continue;
                ChunkTicketPos ticketPos = new ChunkTicketPos(new ChunkPos(x, z), (TicketType<ChunkPos>)ticketType, 2);
                xDiff = predictionPos.f_45578_ - x;
                zDiff = predictionPos.f_45579_ - z;
                ticketPos.distanceToPlayer = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                ticketPos.ticking = true;
                toLoad.add(ticketPos);
            }
        }
        toLoad.sort(Comparator.comparingDouble(ChunkTicketPos::getDistanceToPlayer));
        ChunkLoadingTask newTask = new ChunkLoadingTask(pos, chunkSource, new ArrayDeque<ChunkTicketPos>(toLoad));
        EventHandler.addTickingTask((ResourceKey<Level>)chunkSource.m_7653_().m_46472_(), newTask);
        this.checkExisting(chunkSource.f_8329_);
        if (this.viewDistLoadTask != null) {
            newTask.syncWithLastTask(this.viewDistLoadTask);
            this.viewDistLoadTask.cancel();
        }
        newTask.loadSpeedModifier = 7.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).smartChunkLoadingSpeed;
        this.viewDistLoadTask = newTask;
        this.checkExisting(chunkSource.f_8329_);
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
            BetterChunkLoading.LOGGER.info("Set player chunkloading chunk position to: " + pos + " viewdist:" + viewDistance);
        }
    }

    public static int getTicketLevelForArea(int ticketArea) {
        return ChunkLevel.m_287154_((FullChunkStatus)FullChunkStatus.FULL) - ticketArea;
    }

    public void onLogout(ServerPlayer player) {
        this.updatePlayerViewDistance(null, ((ServerLevel)player.m_9236_()).m_7726_(), 0, this.chunkloadTicketType);
        if (this.predictionTask != null) {
            this.predictionTask.cancel();
        }
    }

    private void checkDirection(ServerPlayer player) {
        this.direction = this.calculatePlayerMovementVec();
        Vec3 currentpos = player.m_20182_();
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enablePrediction) {
            this.checkPrediction(this.direction, currentpos, player);
        }
    }

    private void checkPrediction(Vec3 direction, Vec3 currentPos, ServerPlayer player) {
        Vec3 predictedPos = currentPos.m_82549_(direction.m_82541_().m_82490_((double)(16 * Math.max(3, ((ServerChunkCache)player.m_9236_().m_7726_()).f_8325_.f_140126_ - ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea * 2))));
        for (int i = 0; i < 30 && !player.m_9236_().m_7232_((int)predictedPos.f_82479_ >> 4, (int)predictedPos.f_82481_ >> 4); ++i) {
            predictedPos = predictedPos.m_82549_(direction.m_82541_().m_82548_().m_82490_(16.0));
        }
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
            ChunkPos nextPredictedStartChunk = new ChunkPos((int)predictedPos.f_82479_ >> 4, (int)predictedPos.f_82481_ >> 4);
            BetterChunkLoading.LOGGER.info("Set predictive loading position with area:" + ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea + " to chunk: " + nextPredictedStartChunk + " player chunk:" + player.m_146902_());
        }
        ChunkPos center = new ChunkPos((int)predictedPos.f_82479_ >> 4, (int)predictedPos.f_82481_ >> 4);
        ChunkPos predictionPos = new ChunkPos(player.m_146902_().f_45578_ + (int)direction.m_82541_().m_82542_((double)3.0, (double)3.0, (double)3.0).f_82479_, player.m_146902_().f_45579_ + (int)direction.m_82541_().m_82542_((double)3.0, (double)3.0, (double)3.0).f_82481_);
        int areaRadius = ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea;
        ArrayList<ChunkTicketPos> toLoad = new ArrayList<ChunkTicketPos>();
        for (int x = center.f_45578_ - areaRadius; x < center.f_45578_ + areaRadius; ++x) {
            for (int z = center.f_45579_ - areaRadius; z < center.f_45579_ + areaRadius; ++z) {
                ChunkTicketPos chunkTicketPos;
                int xDiff = center.f_45578_ - x;
                int zDiff = center.f_45579_ - z;
                double distance = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                if (!(distance < (double)areaRadius)) continue;
                ChunkTicketPos ticketPos = new ChunkTicketPos(new ChunkPos(x, z), this.predictionTicketType, 1);
                if (this.viewDistLoadTask != null && ticketPos.equals(chunkTicketPos = this.viewDistLoadTask.loadedChunks.get(ticketPos.pos))) continue;
                xDiff = predictionPos.f_45578_ - x;
                zDiff = predictionPos.f_45579_ - z;
                ticketPos.distanceToPlayer = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                toLoad.add(ticketPos);
            }
        }
        toLoad.sort(Comparator.comparingDouble(ChunkTicketPos::getDistanceToPlayer));
        ChunkLoadingTask newTask = new ChunkLoadingTask(center, ((ServerLevel)player.m_9236_()).m_7726_(), new ArrayDeque<ChunkTicketPos>(toLoad));
        EventHandler.addTickingTask((ResourceKey<Level>)player.m_9236_().m_46472_(), newTask);
        this.checkExisting((ServerLevel)player.m_9236_());
        if (this.predictionTask != null) {
            newTask.syncWithLastTask(this.predictionTask);
            this.predictionTask.cancel();
        }
        this.predictionTask = newTask;
        this.predictionTask.loadSpeedModifier = 10.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionLoadingSpeed;
        this.checkExisting((ServerLevel)player.m_9236_());
        this.predictionTask.tick();
    }

    public void checkExisting(ServerLevel level) {
        if (!BetterChunkLoading.IN_DEV || this.lastChunk == null) {
            return;
        }
        for (Long2ObjectMap.Entry ticketEntry : level.m_7726_().f_8327_.f_140761_.long2ObjectEntrySet()) {
            ChunkPos chunk = new ChunkPos(ticketEntry.getLongKey());
            double distance = chunk.m_45594_(this.lastChunk);
            for (Ticket ticket : (SortedArraySet)ticketEntry.getValue()) {
                if (ticket.m_9428_() != this.chunkloadTicketType && ticket.m_9428_() != this.predictionTicketType) continue;
                boolean tracked = false;
                if (this.predictionTask != null && ticket.m_9428_() == this.predictionTicketType && this.predictionTask.loadedChunks.get(chunk) != null) {
                    if (distance > (double)(this.playerChunkLoadViewDistance * 3)) {
                        BetterChunkLoading.LOGGER.warn("Far distance ticket: " + chunk + " ticket:" + ticket);
                    }
                    tracked = true;
                }
                if (this.viewDistLoadTask != null && ticket.m_9428_() == this.chunkloadTicketType && this.viewDistLoadTask.loadedChunks.get(chunk) != null) {
                    if (distance > (double)(this.playerChunkLoadViewDistance * 3)) {
                        BetterChunkLoading.LOGGER.warn("Far distance ticket: " + chunk + " ticket:" + ticket);
                    }
                    tracked = true;
                }
                if (!tracked && expiringTicketsMap.containsKey(ticketEntry.getLongKey()) && level.m_7726_().f_8327_.f_140771_ - ticket.f_9423_ + 30L + 100L > ticket.m_9428_().m_9469_()) {
                    tracked = true;
                }
                if (tracked) continue;
                BetterChunkLoading.LOGGER.warn("Lost ticket reference at: " + chunk + " ticket:" + ticket);
            }
        }
    }

    private class ChunkLoadingTask
    implements ITickingTask {
        private final ChunkPos center;
        private ServerChunkCache chunkSource;
        private Queue<ChunkTicketPos> chunksToTicket;
        private Map<ChunkPos, ChunkTicketPos> loadedChunks = new HashMap<ChunkPos, ChunkTicketPos>();
        private double loadSpeedModifier = 1.0;
        private double cooldownCounter = 0.0;

        private ChunkLoadingTask(ChunkPos center, ServerChunkCache chunkSource, Queue<ChunkTicketPos> chunksToTicket) {
            this.center = center;
            this.chunkSource = chunkSource;
            this.chunksToTicket = chunksToTicket;
        }

        @Override
        public boolean tick() {
            if (this.chunksToTicket == null || this.chunksToTicket.isEmpty()) {
                return true;
            }
            if (this.cooldownCounter > 1.0) {
                this.cooldownCounter -= 1.0;
                return false;
            }
            int clampedMSTP = Math.min(100, Math.max(EventHandler.MSTP, 40));
            double tpsMod = 1.0;
            tpsMod = clampedMSTP <= 40 ? 4.0 : (clampedMSTP <= 60 ? (double)(clampedMSTP - 40) / 20.0 * -3.0 + 4.0 : (double)(clampedMSTP - 60) / 40.0 * -0.8 + 1.0);
            this.cooldownCounter += (double)this.loadedChunks.size() / (100.0 * this.loadSpeedModifier * tpsMod);
            while (!this.chunksToTicket.isEmpty()) {
                Ticket firstTicket;
                ChunkTicketPos ticketToAdd = this.chunksToTicket.poll();
                SortedArraySet ticketsAtPos = (SortedArraySet)this.chunkSource.f_8327_.f_140761_.get(ticketToAdd.pos.m_45588_());
                Ticket ticket = firstTicket = ticketsAtPos != null ? (Ticket)ticketsAtPos.m_14262_() : null;
                if (firstTicket != null && firstTicket.m_9433_() <= ChunkLevel.m_287154_((FullChunkStatus)FullChunkStatus.FULL) - 1) {
                    this.addTicketfor(ticketToAdd);
                    continue;
                }
                this.addTicketfor(ticketToAdd);
                break;
            }
            return this.chunksToTicket.isEmpty();
        }

        @Override
        public void cancel() {
            for (ChunkTicketPos pos : this.loadedChunks.values()) {
                this.removeTicketfor(pos);
            }
            this.chunksToTicket = null;
            this.loadedChunks = null;
            this.chunkSource = null;
        }

        private void syncWithLastTask(ChunkLoadingTask oldTask) {
            Iterator iterator = this.chunksToTicket.iterator();
            block0: while (iterator.hasNext()) {
                SortedArraySet ticketsAtPos;
                ChunkTicketPos oldPos;
                ChunkTicketPos ticketToAdd = (ChunkTicketPos)iterator.next();
                if (!ticketToAdd.equals(oldPos = oldTask.loadedChunks.get(ticketToAdd.pos)) || this.chunkSource != oldTask.chunkSource || (ticketsAtPos = (SortedArraySet)this.chunkSource.f_8327_.f_140761_.get(ticketToAdd.pos.m_45588_())) == null || ticketsAtPos.isEmpty()) continue;
                for (Ticket ticket : ticketsAtPos) {
                    if (ticket.m_9428_() != ticketToAdd.type || ticket.m_9433_() != PlayerChunkData.getTicketLevelForArea(ticketToAdd.ticketArea)) continue;
                    ticket.m_9429_(this.chunkSource.f_8327_.f_140771_);
                    this.loadedChunks.put(oldPos.pos, ticketToAdd);
                    oldTask.loadedChunks.remove(oldPos.pos);
                    iterator.remove();
                    continue block0;
                }
            }
        }

        private void addTicketfor(ChunkTicketPos ticketPos) {
            this.chunkSource.f_8327_.m_140792_(ticketPos.type, ticketPos.pos, PlayerChunkData.getTicketLevelForArea(ticketPos.ticketArea), (Object)ticketPos.pos);
            ChunkTicketPos prev = this.loadedChunks.put(ticketPos.pos, ticketPos);
            if (prev != null && BetterChunkLoading.IN_DEV) {
                BetterChunkLoading.LOGGER.warn("Error, re-adding ticket twice!");
            }
        }

        private void removeTicketfor(ChunkTicketPos ticketPos) {
            SortedArraySet ticketsAtPos = (SortedArraySet)this.chunkSource.f_8327_.f_140761_.get(ticketPos.pos.m_45588_());
            if (ticketsAtPos != null && !ticketsAtPos.isEmpty()) {
                if (this.chunkSource.m_8364_(ticketPos.pos.m_45588_()).m_212234_() == null) {
                    this.chunkSource.f_8327_.m_140823_(ticketPos.type, ticketPos.pos, PlayerChunkData.getTicketLevelForArea(ticketPos.ticketArea), (Object)ticketPos.pos);
                    return;
                }
                int counter = 0;
                for (Ticket ticket : ticketsAtPos) {
                    ++counter;
                    if (ticket.m_9428_() != ticketPos.type || ticket.m_9433_() != PlayerChunkData.getTicketLevelForArea(ticketPos.ticketArea)) continue;
                    if (BetterChunkLoading.IN_DEV) {
                        ((Set)expiringTicketsMap.computeIfAbsent(ticketPos.pos.m_45588_(), t -> new HashSet())).add(ticket);
                    }
                    ticket.m_9429_(this.chunkSource.f_8327_.f_140771_ - ticket.m_9428_().m_9469_() + 30L + (long)counter);
                    return;
                }
            }
        }
    }

    private static class ChunkTicketPos {
        private double distanceToPlayer = 100.0;
        private final ChunkPos pos;
        private final TicketType<ChunkPos> type;
        private final int ticketArea;
        private boolean ticking = false;

        ChunkTicketPos(ChunkPos pos, TicketType<ChunkPos> type, int ticketLevel) {
            this.pos = pos;
            this.type = type;
            this.ticketArea = ticketLevel;
        }

        public double getDistanceToPlayer() {
            return this.distanceToPlayer;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ChunkTicketPos) {
                ChunkTicketPos ticketPos = (ChunkTicketPos)obj;
                return ticketPos.ticketArea == this.ticketArea && ticketPos.pos.equals((Object)this.pos) && ticketPos.type.equals(this.type) && ticketPos.ticking == this.ticking;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.type, this.ticketArea, this.ticking);
        }
    }
}

