/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.client.render.layer;

import com.aetherteam.aether.client.renderer.entity.model.QuadrupedWingsModel;
import com.aetherteam.aether.entity.passive.WingedAnimal;
import com.legacy.lost_aether.LostContentMod;
import com.legacy.lost_aether.capability.entity.IWingedAnimal;
import com.legacy.lost_aether.capability.entity.WingedAnimalCap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class ColoredWingsLayer<T extends WingedAnimal, M extends QuadrupedModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation BRONZE_WINGS = LostContentMod.locate("textures/entity/bronze_wings.png");
    private static final ResourceLocation SILVER_WINGS = LostContentMod.locate("textures/entity/silver_wings.png");
    private final RenderType bronzeType;
    private final RenderType silverType;
    private final QuadrupedWingsModel<T> wingModel;

    public ColoredWingsLayer(RenderLayerParent<T, M> entityRenderer, QuadrupedWingsModel<T> wingsModel) {
        super(entityRenderer);
        this.wingModel = wingsModel;
        this.bronzeType = RenderType.m_110458_((ResourceLocation)BRONZE_WINGS);
        this.silverType = RenderType.m_110458_((ResourceLocation)SILVER_WINGS);
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IWingedAnimal cap = WingedAnimalCap.get(entity);
        if (cap != null && cap.shouldDisplayWings()) {
            byte type = cap.getWingType();
            if (entity.m_6162_()) {
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_252880_(0.0f, 1.5f, 0.0f);
            }
            this.wingModel.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer consumer = buffer.m_6299_(type == WingedAnimalCap.WingType.SILVER.ordinal() ? this.silverType : this.bronzeType);
            this.wingModel.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

