/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.data;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import umpaz.nethersdelight.common.registry.NDItems;
import umpaz.nethersdelight.common.tag.NDTags;
import umpaz.nethersdelight.data.builder.NDCookingPotRecipeBuilder;
import umpaz.nethersdelight.data.builder.NDCuttingBoardRecipeBuilder;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;

public class NDRecipes
extends RecipeProvider {
    private final List<IRecipeContainer> recipeContainers = List.of(new Crafting(), new Smelting(), new Smithing(), new CookingPot(), new CuttingBoard());

    public NDRecipes(PackOutput output) {
        super(output);
    }

    protected void m_245200_(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.recipeContainers.forEach(container -> container.buildRecipes(consumer));
    }

    private static class Crafting
    implements IRecipeContainer {
        private Crafting() {
        }

        @Override
        public void buildRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NDItems.SOUL_COMPOST.get())).m_126209_((ItemLike)Items.f_42050_).m_126209_((ItemLike)Items.f_41908_).m_126209_((ItemLike)Items.f_41908_).m_126209_((ItemLike)Items.f_42499_).m_126209_((ItemLike)Items.f_42499_).m_126209_((ItemLike)Items.f_41957_).m_126209_((ItemLike)Items.f_41957_).m_126209_((ItemLike)Items.f_41957_).m_126209_((ItemLike)Items.f_41957_).m_126132_("has_soil", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42050_})).m_126140_(consumer, new ResourceLocation("nethersdelight", "soul_compost_from_warped_roots"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NDItems.SOUL_COMPOST.get())).m_126209_((ItemLike)Items.f_42050_).m_126209_((ItemLike)NDItems.HOGLIN_HIDE.get()).m_126209_((ItemLike)NDItems.HOGLIN_HIDE.get()).m_126209_((ItemLike)Items.f_41908_).m_126209_((ItemLike)Items.f_41908_).m_126209_((ItemLike)Items.f_42499_).m_126209_((ItemLike)Items.f_42499_).m_126209_((ItemLike)Items.f_42499_).m_126209_((ItemLike)Items.f_42499_).m_126132_("has_soil", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42050_})).m_126140_(consumer, new ResourceLocation("nethersdelight", "soul_compost_from_hoglin_hide"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)NDItems.WARPED_MOLDY_MEAT.get())).m_126209_((ItemLike)Items.f_41957_).m_126209_((ItemLike)Items.f_41957_).m_126209_((ItemLike)NDItems.HOGLIN_SIRLOIN.get()).m_126209_((ItemLike)Items.f_42399_).m_126132_("has_sirloin", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.HOGLIN_SIRLOIN.get()})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)NDItems.BLACKSTONE_FURNACE.get())).m_126130_("###").m_126130_("# #").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42755_).m_126132_("has_blackstone", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42755_})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)NDItems.BLACKSTONE_BLAST_FURNACE.get())).m_126130_("###").m_126130_("#b#").m_126130_("sss").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('b'), (ItemLike)NDItems.BLACKSTONE_FURNACE.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42759_).m_126132_("has_iron", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42416_})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)NDItems.NETHER_BRICK_SMOKER.get())).m_126130_(" n ").m_126130_("nbn").m_126130_(" n ").m_126127_(Character.valueOf('n'), (ItemLike)Items.f_42095_).m_126127_(Character.valueOf('b'), (ItemLike)NDItems.BLACKSTONE_FURNACE.get()).m_126132_("has_nether_bricks", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42095_})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)NDItems.IRON_MACHETE.get())).m_126130_("  m").m_126130_(" m ").m_126130_("s  ").m_206416_(Character.valueOf('m'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_).m_126132_("has_iron_ingot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42416_})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)NDItems.DIAMOND_MACHETE.get())).m_126130_("  m").m_126130_(" m ").m_126130_("s  ").m_126127_(Character.valueOf('m'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_).m_126132_("has_diamond", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42415_})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)NDItems.GOLDEN_MACHETE.get())).m_126130_("  m").m_126130_(" m ").m_126130_("s  ").m_126127_(Character.valueOf('m'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_).m_126132_("has_gold_ingot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42417_})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)NDItems.BLACKSTONE_STOVE.get())).m_126130_("nnn").m_126130_("b b").m_126130_("bcb").m_126127_(Character.valueOf('n'), (ItemLike)Items.f_42691_).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42763_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42781_).m_126132_("has_nether_brick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42691_})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)NDItems.NETHER_SKEWER.get())).m_126130_("ps").m_126130_("b ").m_126127_(Character.valueOf('p'), (ItemLike)NDItems.PROPELPEARL.get()).m_206416_(Character.valueOf('s'), NDTags.RAW_STRIDER).m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42585_).m_126132_("has_propelpearl", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.PROPELPEARL.get()})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)NDItems.RAW_STUFFED_HOGLIN.get())).m_126130_("wfc").m_126130_("l#l").m_126130_("hsh").m_126127_(Character.valueOf('w'), (ItemLike)Items.f_41957_).m_126127_(Character.valueOf('f'), (ItemLike)Items.f_41954_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_41956_).m_126127_(Character.valueOf('l'), (ItemLike)NDItems.HOGLIN_LOIN.get()).m_126127_(Character.valueOf('#'), (ItemLike)NDItems.HOGLIN_HIDE.get()).m_126127_(Character.valueOf('h'), (ItemLike)ModItems.HAM.get()).m_126127_(Character.valueOf('s'), (ItemLike)ModItems.NETHER_SALAD.get()).m_126132_("has_hoglin_hide", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.HOGLIN_HIDE.get()})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)NDItems.HOGLIN_TROPHY.get())).m_126130_("php").m_126130_("pwp").m_126130_("ggg").m_206416_(Character.valueOf('p'), ItemTags.f_13168_).m_126127_(Character.valueOf('h'), (ItemLike)NDItems.HOGLIN_HIDE.get()).m_206416_(Character.valueOf('w'), ItemTags.f_13167_).m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42587_).m_126132_("has_hoglin_hide", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.HOGLIN_HIDE.get()})).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)NDItems.PROPELPLANT_TORCH.get())).m_126130_("p").m_126130_("c").m_126127_(Character.valueOf('p'), (ItemLike)NDItems.PROPELPEARL.get()).m_126127_(Character.valueOf('c'), (ItemLike)NDItems.PROPELPLANT_CANE.get()).m_126132_("has_propelplant", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.PROPELPEARL.get()})).m_176498_(consumer);
        }
    }

    private static class Smelting
    implements IRecipeContainer {
        private Smelting() {
        }

        @Override
        public void buildRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
            this.foodSmeltingRecipe("hoglin_sirloin", (ItemLike)NDItems.HOGLIN_LOIN.get(), (ItemLike)NDItems.HOGLIN_SIRLOIN.get(), 0.35f, consumer);
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.IRON_MACHETE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42749_, (float)0.1f, (int)200).m_126132_("has_iron_machete", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.IRON_MACHETE.get()})).m_126140_(consumer, new ResourceLocation("nethersdelight", "iron_nugget_from_smelting_machete"));
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.GOLDEN_MACHETE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42587_, (float)0.1f, (int)200).m_126132_("has_golden_machete", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.GOLDEN_MACHETE.get()})).m_126140_(consumer, new ResourceLocation("nethersdelight", "gold_nugget_from_smelting_machete"));
            SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.IRON_MACHETE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42749_, (float)0.1f, (int)100).m_126132_("has_iron_machete", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.IRON_MACHETE.get()})).m_126140_(consumer, new ResourceLocation("nethersdelight", "iron_nugget_from_blasting_machete"));
            SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.GOLDEN_MACHETE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42587_, (float)0.1f, (int)100).m_126132_("has_golden_machete", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.GOLDEN_MACHETE.get()})).m_126140_(consumer, new ResourceLocation("nethersdelight", "gold_nugget_from_blasting_machete"));
        }

        private void foodSmeltingRecipe(String name, ItemLike ingredient, ItemLike result, float experience, Consumer<FinishedRecipe> consumer) {
            String namePrefix = new ResourceLocation("nethersdelight", name).toString();
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)200).m_126132_(name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient})).m_176498_(consumer);
            SimpleCookingRecipeBuilder.m_247020_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)600).m_126132_(name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient})).m_176500_(consumer, namePrefix + "_from_campfire_cooking");
            SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)100).m_126132_(name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient})).m_176500_(consumer, namePrefix + "_from_smoking");
        }
    }

    private static class Smithing
    implements IRecipeContainer {
        private Smithing() {
        }

        @Override
        public void buildRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
            NDRecipes.m_246630_((Consumer)consumer, (Item)((Item)NDItems.DIAMOND_MACHETE.get()), (RecipeCategory)RecipeCategory.TOOLS, (Item)((Item)NDItems.NETHERITE_MACHETE.get()));
        }
    }

    private static class CookingPot
    implements IRecipeContainer {
        public static final int FAST_COOKING = 100;
        public static final int NORMAL_COOKING = 200;
        public static final int SLOW_COOKING = 400;
        public static final float SMALL_EXP = 0.35f;
        public static final float MEDIUM_EXP = 1.0f;
        public static final float LARGE_EXP = 2.0f;

        private CookingPot() {
        }

        @Override
        public void buildRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
            CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)NDItems.STUFFED_HOGLIN.get()), (int)1, (int)400, (float)2.0f).addIngredient((ItemLike)ModItems.NETHER_SALAD.get()).addIngredient((ItemLike)NDItems.RAW_STUFFED_HOGLIN.get()).addIngredient((ItemLike)ModItems.NETHER_SALAD.get()).unlockedByItems("has_raw_stuffed_hoglin", new ItemLike[]{(ItemLike)NDItems.RAW_STUFFED_HOGLIN.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
            NDCookingPotRecipeBuilder.cookingPotRecipe((ItemLike)NDItems.GRILLED_STRIDER.get(), 1, 200, 1.0f).addIngredient(NDTags.RAW_STRIDER).addIngredient((ItemLike)Items.f_41955_).addIngredient((ItemLike)Items.f_41954_).addIngredient((ItemLike)Items.f_41957_).addIngredient((ItemLike)Items.f_41956_).unlockedByItems("has_strider_slice", (ItemLike)NDItems.STRIDER_SLICE.get()).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
            NDCookingPotRecipeBuilder.cookingPotRecipe((ItemLike)NDItems.MAGMA_GELATIN.get(), 1, 200, 1.0f, (ItemLike)Items.f_42448_).addIngredient((ItemLike)Items.f_42542_).addIngredient((ItemLike)Items.f_42542_).addIngredient((ItemLike)Items.f_42542_).addIngredient((ItemLike)NDItems.PROPELPEARL.get()).unlockedByItems("has_propelpearl", (ItemLike)NDItems.PROPELPEARL.get()).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(consumer);
            NDCookingPotRecipeBuilder.cookingPotRecipe((ItemLike)NDItems.STRIDER_MOSS_STEW.get(), 1, 200, 1.0f).addIngredient((ItemLike)Items.f_41955_).addIngredient((ItemLike)Items.f_41954_).addIngredient((ItemLike)Items.f_41956_).addIngredient((ItemLike)Items.f_41955_).addIngredient(NDTags.RAW_STRIDER).unlockedByItems("has_strider_slice", (ItemLike)NDItems.STRIDER_SLICE.get()).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer);
        }
    }

    private static class CuttingBoard
    implements IRecipeContainer {
        private CuttingBoard() {
        }

        @Override
        public void buildRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
            NDCuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.STRIDER_SLICE.get()}), Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)NDItems.GROUND_STRIDER.get(), 2).build(consumer);
            NDCuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.CRIMSON_FUNGUS_COLONY.get()}), Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_41954_, 5).build(consumer);
            NDCuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.WARPED_FUNGUS_COLONY.get()}), Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_41955_, 5).build(consumer);
            NDCuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.HOGLIN_HIDE.get()}), Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_42454_, 4).build(consumer);
            NDCuttingBoardRecipeBuilder.cuttingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NDItems.PROPELPLANT_CANE.get()}), Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)Items.f_42403_).build(consumer);
        }
    }

    private static interface IRecipeContainer {
        public void buildRecipes(@Nonnull Consumer<FinishedRecipe> var1);
    }
}

