/*
 * Decompiled with CFR 0.152.
 */
package com.h1ggsk.betterworldloading20.mixin;

import com.h1ggsk.betterworldloading20.config.BWLMidnightConfig;
import com.h1ggsk.betterworldloading20.mixin.LevelLoadingScreenAccessor;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelLoadingScreen.class}, priority=0x7FFFFFFF)
public abstract class MixinAddChunkBar {
    @Unique
    private static float lastProgress = -1.0f;

    @Inject(method={"renderChunks"}, at={@At(value="HEAD")}, cancellable=true)
    private static void disableChunkMap(GuiGraphics guiGraphics, StoringChunkProgressListener progressListener, int centerX, int centerY, int size, int spacing, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void replaceChunkMapWithBar(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        LevelLoadingScreen self = (LevelLoadingScreen)this;
        StoringChunkProgressListener tracker = ((LevelLoadingScreenAccessor)self).getProgressListener();
        int barWidth = 200;
        int barHeight = 6;
        int centerX = self.f_96543_ / 2;
        int centerY = self.f_96544_ / 2;
        int x0 = centerX - barWidth / 2;
        int y0 = centerY - barHeight / 2;
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        float progress = Mth.m_14036_((float)((float)tracker.m_9674_() / 100.0f), (float)0.0f, (float)1.0f);
        guiGraphics.m_280509_(x0, y0, x0 + barWidth, y0 + barHeight, -13421773);
        int filledWidth = Mth.m_14143_((float)(progress * (float)barWidth));
        guiGraphics.m_280509_(x0 + 1, y0 + 1, x0 + 1 + Math.max(filledWidth - 2, 0), y0 + barHeight - 1, -4473925);
        int totalChunks = tracker.m_9673_();
        if (totalChunks > 0) {
            int currentChunks = Math.round(progress * (float)totalChunks);
            String text = String.format("%d/%d chunks", currentChunks, totalChunks);
            int textY = y0 + barHeight + 4;
            guiGraphics.m_280137_(font, text, centerX, textY, 0xFFFFFF);
            if (BWLMidnightConfig.enableChunkInfo) {
                HashMap<ChunkStatus, Integer> statusCounts = new HashMap<ChunkStatus, Integer>();
                for (int x = 0; x < totalChunks; ++x) {
                    for (int z = 0; z < totalChunks; ++z) {
                        ChunkStatus status = tracker.m_9663_(x, z);
                        statusCounts.put(status, statusCounts.getOrDefault(status, 0) + 1);
                    }
                }
                Object[][] statusEntries = new Object[][]{{ChunkStatus.f_62314_, "Empty", -11250604}, {ChunkStatus.f_62315_, "Structure Starts", -6710887}, {ChunkStatus.f_62316_, "Structure References", -10526319}, {ChunkStatus.f_62317_, "Biomes", -8342958}, {ChunkStatus.f_62318_, "Noise", -3026479}, {ChunkStatus.f_62319_, "Surface", -9279479}, {ChunkStatus.f_62320_, "Carvers", -13617806}, {ChunkStatus.f_62322_, "Features", -14563840}, {ChunkStatus.f_279614_, "Initialize Light", -3355444}, {ChunkStatus.f_62323_, "Light", -8032}, {ChunkStatus.f_62324_, "Spawn", -892832}, {ChunkStatus.f_62326_, "Full", -1}};
                Objects.requireNonNull(font);
                int startY = textY + 9 + 8;
                Objects.requireNonNull(font);
                int lineHeight = 9 + 2;
                int squareSize = 8;
                int squareMargin = 4;
                for (Object[] entry : statusEntries) {
                    ChunkStatus status = (ChunkStatus)entry[0];
                    String name = (String)entry[1];
                    int color = (Integer)entry[2];
                    int count = statusCounts.getOrDefault(status, 0);
                    if (count == 0) continue;
                    String displayText = String.format("%s: %d", name, count);
                    int textWidth = font.m_92895_(displayText);
                    int totalWidth = squareSize + squareMargin + textWidth;
                    int startX = centerX - totalWidth / 2;
                    guiGraphics.m_280509_(startX, startY, startX + squareSize, startY + squareSize, color);
                    guiGraphics.m_280056_(font, displayText, startX + squareSize + squareMargin, startY, 0xFFFFFF, false);
                    startY += lineHeight;
                }
            }
        }
        if (BWLMidnightConfig.enableLoadingSound) {
            this.handleProgressSounds(progress);
        }
    }

    @Unique
    private void handleProgressSounds(float currentProgress) {
        if (currentProgress == 0.0f) {
            lastProgress = -1.0f;
            return;
        }
        if (lastProgress == -1.0f) {
            lastProgress = currentProgress;
            return;
        }
        if (currentProgress > lastProgress) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundEvents.f_12215_.get()), (float)1.5f, (float)0.7f));
            lastProgress = currentProgress;
        }
    }
}

