/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.vinery.core.block.entity.StorageBlockEntity;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.WineYears;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrinkBlockItem
extends BlockItem {
    private final int baseDuration;
    private final boolean scaleDurationWithAge;
    private final BottleSize bottleSize;

    public DrinkBlockItem(Block block, Item.Properties settings, int baseDuration, boolean scaleDurationWithAge, BottleSize bottleSize) {
        super(block, settings);
        this.baseDuration = baseDuration;
        this.scaleDurationWithAge = scaleDurationWithAge;
        this.bottleSize = bottleSize;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    protected BlockState m_5965_(BlockPlaceContext context) {
        if (!Objects.requireNonNull(context.m_43723_()).m_6047_()) {
            return null;
        }
        BlockState blockState = this.m_40614_().m_5573_(context);
        return blockState != null && this.m_40610_(context, blockState) ? blockState : null;
    }

    protected boolean m_7274_(BlockPos blockPos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity wineEntity = (StorageBlockEntity)blockEntity;
            wineEntity.setStack(0, itemStack.m_255036_(1));
        }
        return super.m_7274_(blockPos, level, player, itemStack, blockState);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        ArrayList effects;
        List list = effects = this.m_41473_() != null ? this.m_41473_().m_38749_() : Lists.newArrayList();
        if (effects.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (Pair effectPair : effects) {
                MobEffectInstance effectInstance = (MobEffectInstance)effectPair.getFirst();
                MobEffect effect = effectInstance.m_19544_();
                String effectName = effect.m_19482_().getString();
                int amplifier = Math.max(0, WineYears.getEffectLevel(stack, world));
                String amplifierRoman = amplifier > 0 ? " " + this.toRoman(amplifier) : "";
                int durationTicks = this.scaleDurationWithAge ? WineYears.getEffectDuration(stack, world) : this.baseDuration;
                durationTicks = Math.max(0, durationTicks);
                String formattedDuration = this.formatDuration(durationTicks);
                String tooltipText = effectName + amplifierRoman + " (" + formattedDuration + ")";
                tooltip.add((Component)Component.m_237113_((String)tooltipText).m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        tooltip.add((Component)Component.m_237119_());
        if (world != null) {
            int age = Math.max(0, WineYears.getWineAge(stack, world));
            int ageDays = WineYears.getWineAgeDays(stack, world);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.vinery.age", (Object[])new Object[]{age}).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)Component.m_237119_());
            int daysToNextUpgrade = WineYears.YEARS_PER_EFFECT_LEVEL * WineYears.DAYS_PER_YEAR - ageDays % (WineYears.YEARS_PER_EFFECT_LEVEL * WineYears.DAYS_PER_YEAR);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.vinery.next_upgrade", (Object[])new Object[]{daysToNextUpgrade}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)9684093))));
        }
        tooltip.add((Component)Component.m_237115_((String)("tooltip.vinery.bottle_size." + this.bottleSize.name().toLowerCase())).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }

    @NotNull
    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        if (!level.f_46443_) {
            int duration = this.scaleDurationWithAge ? Math.max(0, WineYears.getEffectDuration(itemStack, level)) : this.baseDuration;
            int amplifier = Math.max(0, WineYears.getEffectLevel(itemStack, level));
            List effects = Objects.requireNonNull(this.m_41473_()).m_38749_();
            for (Pair effectPair : effects) {
                MobEffect effect = ((MobEffectInstance)effectPair.getFirst()).m_19544_();
                livingEntity.m_7292_(new MobEffectInstance(effect, duration, amplifier));
            }
        }
        itemStack.m_41774_(1);
        return GeneralUtil.convertStackAfterFinishUsing(livingEntity, itemStack, (Item)ObjectRegistry.WINE_BOTTLE.get(), (Item)this);
    }

    private String formatDuration(int ticks) {
        int totalSeconds = Math.max(0, ticks) / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%d:%02d", minutes, seconds);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        super.m_7836_(stack, world, player);
        WineYears.setWineYear(stack, world);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (world != null && !world.f_46443_) {
            if (!WineYears.hasWineYear(stack)) {
                WineYears.setWineYear(stack, world);
            } else if (world.m_46467_() % 200L == 0L) {
                WineYears.refreshCached(stack, world);
            }
        }
    }

    private String toRoman(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> String.valueOf(number);
        };
    }

    @PlatformOnly(value={"forge"})
    public CompoundTag getShareTag(ItemStack stack) {
        return WineYears.getShareTag(stack);
    }

    @PlatformOnly(value={"forge"})
    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        WineYears.readShareTag(stack, nbt);
    }

    public static enum BottleSize {
        SMALL,
        BIG;

    }
}

