/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.util.WineYears;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WineDebugCommands {
    private static final Logger LOGGER = LogManager.getLogger((String)"Vinery");

    public static void init() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, selection) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wine").requires(src -> true)).then(Commands.m_82127_((String)"age").then(Commands.m_82129_((String)"years", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100000)).executes(ctx -> WineDebugCommands.ageHeld((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"years")))))).then(Commands.m_82127_((String)"info").executes(ctx -> WineDebugCommands.infoHeld((CommandSourceStack)ctx.getSource()))));
            LOGGER.info("Registered /wine command");
        });
    }

    private static int ageHeld(CommandSourceStack source, int years) {
        ServerPlayer player = source.m_230896_();
        if (player == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Player required"));
            return 0;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            source.m_81352_((Component)Component.m_237113_((String)"No item in main hand"));
            return 0;
        }
        ServerLevel level = player.m_284548_();
        int targetYear = WineYears.getYear((Level)level) - years;
        stack.m_41784_().m_128405_("Year", targetYear);
        WineYears.refreshCached(stack, (Level)level);
        source.m_288197_(() -> Component.m_237113_((String)("Wine age set to " + years + " years")), false);
        return 1;
    }

    private static int infoHeld(CommandSourceStack source) {
        ServerPlayer player = source.m_230896_();
        if (player == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Player required"));
            return 0;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            source.m_81352_((Component)Component.m_237113_((String)"No item in main hand"));
            return 0;
        }
        ServerLevel level = player.m_284548_();
        int age = WineYears.getWineAge(stack, (Level)level);
        int days = WineYears.getWineAgeDays(stack, (Level)level);
        int amplifier = WineYears.getEffectLevel(stack, (Level)level);
        int duration = WineYears.getEffectDuration(stack, (Level)level);
        source.m_288197_(() -> Component.m_237113_((String)("Age: " + age + "y, " + days + "d | Amp: " + amplifier + " | Dur: " + duration + " ticks")), false);
        return 1;
    }
}

