/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.helpers;

import auviotre.enigmatic.addon.contents.brewing.AddonBrewingRecipe;
import auviotre.enigmatic.addon.contents.entities.UltimatePotionEntity;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.registries.EnigmaticAddonPotions;
import com.aizistral.enigmaticlegacy.entities.EnigmaticPotionEntity;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.helpers.PotionHelper;
import com.aizistral.enigmaticlegacy.objects.AdvancedPotion;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.enigmaticlegacy.registries.EnigmaticPotions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class PotionAddonHelper {
    public static final Ingredient SPECIAL_POTIONS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42787_, EnigmaticAddonItems.ASTRAL_POTION, EnigmaticAddonItems.COMMON_POTION_LINGERING, EnigmaticAddonItems.ULTIMATE_POTION_LINGERING});
    private static final Ingredient BLUE_ICE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42363_});
    private static final Ingredient REDSTONE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_});
    private static final Ingredient GUNPOWDER = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_});
    private static final Ingredient GLOWSTONE_DUST = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_});
    private static final Ingredient DRAGON_BREATH = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42735_});
    private static final Ingredient ICHOR = Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticAddonItems.ICHOR_DROPLET});
    private static final Ingredient ASTRAL_DUST = Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ASTRAL_DUST});
    private static final Ingredient EARTH_HEART_FRAGMENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticAddonItems.EARTH_HEART_FRAGMENT});
    private static final Ingredient FERMENTED_SPIDER_EYE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_});
    private static final String defaultPotion = "nothingAddon";
    private static final AbstractProjectileDispenseBehavior potionBehavior = new AbstractProjectileDispenseBehavior(){

        protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
            EnigmaticPotionEntity potionEntity = new EnigmaticPotionEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
            potionEntity.m_37446_(stackIn);
            return potionEntity;
        }
    };
    private static final AbstractProjectileDispenseBehavior addonPotionBehavior = new AbstractProjectileDispenseBehavior(){

        protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
            UltimatePotionEntity potionEntity = new UltimatePotionEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
            potionEntity.m_37446_(stackIn);
            return potionEntity;
        }
    };

    public static void registerCommonPotions() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43602_)}), EARTH_HEART_FRAGMENT}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.LUCK)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43602_)}), EARTH_HEART_FRAGMENT}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.LUCK)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43602_)}), EARTH_HEART_FRAGMENT}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.LUCK)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43600_)}), BLUE_ICE}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.FROZEN_HEART)}), REDSTONE}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.LONG_FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43600_)}), BLUE_ICE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.FROZEN_HEART)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.FROZEN_HEART)}), REDSTONE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.LONG_FROZEN_HEART)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.LONG_FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43600_)}), BLUE_ICE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.FROZEN_HEART)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.FROZEN_HEART)}), REDSTONE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.LONG_FROZEN_HEART)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.LONG_FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION, (AdvancedPotion)EnigmaticPotions.HASTE)}), FERMENTED_SPIDER_EYE}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION, (AdvancedPotion)EnigmaticPotions.LONG_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)}), REDSTONE}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.LONG_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION, (AdvancedPotion)EnigmaticPotions.STRONG_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)}), GLOWSTONE_DUST}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticPotions.HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticPotions.LONG_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.LONG_MINING_FATIGUE)}), GUNPOWDER, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)}), REDSTONE}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.LONG_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticPotions.STRONG_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)}), GUNPOWDER, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)}), GLOWSTONE_DUST}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticPotions.HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticPotions.LONG_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.LONG_MINING_FATIGUE)}), DRAGON_BREATH, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)}), REDSTONE}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.LONG_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticPotions.STRONG_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)}), DRAGON_BREATH, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.MINING_FATIGUE)}), GLOWSTONE_DUST}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)));
    }

    public static void registerUltimatePotions() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.LONG_FROZEN_HEART)}), ASTRAL_DUST}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.LONG_FROZEN_HEART)}), ASTRAL_DUST, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_FROZEN_HEART)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.LONG_FROZEN_HEART)}), ASTRAL_DUST, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_FROZEN_HEART)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_FROZEN_HEART)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticPotions.ULTIMATE_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.LONG_MINING_FATIGUE)}), ASTRAL_DUST, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)}), ASTRAL_DUST}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticPotions.ULTIMATE_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.LONG_MINING_FATIGUE)}), ASTRAL_DUST, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)}), ASTRAL_DUST, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_MINING_FATIGUE)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticPotions.ULTIMATE_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.LONG_MINING_FATIGUE)}), ASTRAL_DUST, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)}), ASTRAL_DUST, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_MINING_FATIGUE)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.ULTIMATE_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43609_)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_LEAPING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43609_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_LEAPING)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_LEAPING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43609_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_LEAPING)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_LEAPING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43614_)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SWIFTNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43614_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SWIFTNESS)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SWIFTNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43614_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SWIFTNESS)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SWIFTNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SWIFTNESS)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43617_)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SLOWNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SWIFTNESS)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43617_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SLOWNESS)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SLOWNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SWIFTNESS)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43617_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SLOWNESS)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_SLOWNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43620_)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_TURTLE_MASTER)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43620_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_TURTLE_MASTER)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_TURTLE_MASTER)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43620_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_TURTLE_MASTER)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_TURTLE_MASTER)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43586_)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_POISON)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43586_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_POISON)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_POISON)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43586_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_POISON)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_POISON)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43589_)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_REGENERATION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43589_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_REGENERATION)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_REGENERATION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43589_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_REGENERATION)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_REGENERATION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43592_)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_STRENGTH)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43592_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_STRENGTH)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_STRENGTH)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43592_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_STRENGTH)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_STRENGTH)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42589_, (Potion)Potions.f_43593_)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_WEAKNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42736_, (Potion)Potions.f_43593_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_WEAKNESS)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_WEAKNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion((Item)Items.f_42739_, (Potion)Potions.f_43593_)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_WEAKNESS)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_WEAKNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION, (AdvancedPotion)EnigmaticPotions.STRONG_HASTE)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticPotions.STRONG_HASTE)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_HASTE)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticPotions.STRONG_HASTE)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_HASTE)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)}), ICHOR}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_MINING_FATIGUE)}), GUNPOWDER}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_MINING_FATIGUE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AddonBrewingRecipe(PotionHelper.constructIngredientMap((Ingredient[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_HASTE)}), FERMENTED_SPIDER_EYE, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.COMMON_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.STRONG_MINING_FATIGUE)}), ICHOR, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_MINING_FATIGUE)}), DRAGON_BREATH}), PotionHelper.createAdvancedPotion((Item)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (AdvancedPotion)EnigmaticAddonPotions.EXTREME_MINING_FATIGUE)));
    }

    public static void registerDispenserBehavior() {
        DispenserBlock.m_52672_((ItemLike)EnigmaticItems.COMMON_POTION_SPLASH, (DispenseItemBehavior)potionBehavior);
        DispenserBlock.m_52672_((ItemLike)EnigmaticItems.COMMON_POTION_LINGERING, (DispenseItemBehavior)potionBehavior);
        DispenserBlock.m_52672_((ItemLike)EnigmaticAddonItems.COMMON_POTION_SPLASH, (DispenseItemBehavior)addonPotionBehavior);
        DispenserBlock.m_52672_((ItemLike)EnigmaticAddonItems.COMMON_POTION_LINGERING, (DispenseItemBehavior)addonPotionBehavior);
        DispenserBlock.m_52672_((ItemLike)EnigmaticItems.ULTIMATE_POTION_SPLASH, (DispenseItemBehavior)potionBehavior);
        DispenserBlock.m_52672_((ItemLike)EnigmaticItems.ULTIMATE_POTION_LINGERING, (DispenseItemBehavior)potionBehavior);
        DispenserBlock.m_52672_((ItemLike)EnigmaticAddonItems.ULTIMATE_POTION_SPLASH, (DispenseItemBehavior)addonPotionBehavior);
        DispenserBlock.m_52672_((ItemLike)EnigmaticAddonItems.ULTIMATE_POTION_LINGERING, (DispenseItemBehavior)addonPotionBehavior);
    }

    public static int getColor(ItemStack stack) {
        return PotionHelper.isAdvancedPotion((ItemStack)stack) && PotionAddonHelper.getEffects(stack) != null && !PotionAddonHelper.getEffects(stack).isEmpty() ? PotionUtils.m_43564_(PotionAddonHelper.getEffects(stack)) : PotionUtils.m_43575_((ItemStack)stack);
    }

    public static AdvancedPotion getAdvancedPotion(ItemStack stack) {
        return PotionHelper.isAdvancedPotion((ItemStack)stack) ? PotionAddonHelper.getAdvancedPotion(ItemNBTHelper.getString((ItemStack)stack, (String)"EnigmaticPotion", (String)defaultPotion)) : EnigmaticPotions.EMPTY_POTION;
    }

    public static List<MobEffectInstance> getEffects(ItemStack stack) {
        AdvancedPotion potion;
        if (PotionHelper.isAdvancedPotion((ItemStack)stack) && (potion = PotionAddonHelper.getAdvancedPotion(ItemNBTHelper.getString((ItemStack)stack, (String)"EnigmaticPotion", (String)defaultPotion))) != null) {
            return potion.getEffects();
        }
        return new ArrayList<MobEffectInstance>();
    }

    public static AdvancedPotion getAdvancedPotion(String identifier) {
        AdvancedPotion potion;
        Iterator<AdvancedPotion> iterator = EnigmaticAddonPotions.ULTIMATE_POTIONS.iterator();
        do {
            if (iterator.hasNext()) continue;
            iterator = EnigmaticAddonPotions.COMMON_POTIONS.iterator();
            do {
                if (iterator.hasNext()) continue;
                return EnigmaticPotions.EMPTY_POTION;
            } while (!(potion = iterator.next()).getId().equals(identifier));
            return potion;
        } while (!(potion = iterator.next()).getId().equals(identifier));
        return potion;
    }
}

