/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.objects.etheriumSheild;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.contents.objects.etheriumSheild.IEtheriumShieldData;
import auviotre.enigmatic.addon.packets.server.PacketEtheriumShieldSync;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class EtheriumShieldCapability {
    public static final Capability<IEtheriumShieldData> ETHERIUM_SHIELD_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEtheriumShieldData>(){});
    public static final ResourceLocation ID_ETHERIUM_SHIELD_DATA = new ResourceLocation("enigmaticaddons", "etherium_shield_data");

    public static ICapabilityProvider createProvider() {
        return new Provider();
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        final LazyOptional<IEtheriumShieldData> optional;
        final IEtheriumShieldData handler = new Wrapper();

        Provider() {
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return ETHERIUM_SHIELD_DATA.orEmpty(capability, this.optional);
        }

        public CompoundTag serializeNBT() {
            return this.handler.writeTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.handler.readTag(nbt);
        }
    }

    public static class Wrapper
    implements IEtheriumShieldData {
        int shieldTick = 0;
        boolean init = true;

        @Override
        public int getTick() {
            return this.shieldTick;
        }

        @Override
        public void setTick(int tick) {
            this.shieldTick = tick;
        }

        @Override
        public void reset() {
            this.shieldTick = 0;
        }

        @Override
        public void tick(Player player) {
            this.tick(player, 1);
        }

        @Override
        public void tick(Player player, int count) {
            if (this.init) {
                this.init = false;
            } else if (player.m_6084_()) {
                this.shieldTick = Math.max(0, this.shieldTick - count);
            }
            this.update((ServerPlayer)player);
        }

        private void update(ServerPlayer player) {
            EnigmaticAddons.packetInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEtheriumShieldSync(this.shieldTick));
        }

        @Override
        public CompoundTag writeTag() {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("EtheriumShieldTick", this.shieldTick);
            return compound;
        }

        @Override
        public void readTag(CompoundTag nbt) {
            this.shieldTick = nbt.m_128451_("EtheriumShieldTick");
        }
    }
}

