/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.api.items.IBlessed;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEffects;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.entities.PermanentItemEntity;
import com.aizistral.enigmaticlegacy.handlers.SoulArchive;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.SoulCrystal;
import com.aizistral.enigmaticlegacy.items.TheAcknowledgment;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TheBless
extends TheAcknowledgment
implements ICursed,
IBlessed {
    public static Omniconfig.DoubleParameter attackDamage;
    public static Omniconfig.DoubleParameter attackSpeed;
    public static Omniconfig.IntParameter invulnerableTime;

    public TheBless() {
        super(TheBless.getDefaultProperties().m_41497_(Rarity.EPIC).m_41487_(1).m_41486_(), "the_bless", attackDamage.getValue(), attackSpeed.getValue());
        this.setAllowAllEnchantments(true);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("TheBless");
        attackDamage = builder.comment("Attack damage of The Bless, actual damage shown in tooltip will be ( 1 + this value ).").max(32768.0).getDouble("AttackDamage", 6.0);
        attackSpeed = builder.comment("Attack speed of The Bless.").minMax(32768.0).getDouble("AttackSpeed", -1.6);
        invulnerableTime = builder.comment("The invulnerable time after hit while The Bless in inventory.").min(40.0).max(200.0).getInt("InvulnerableTime", 40);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            if (Minecraft.m_91087_().f_91074_ != null && SuperAddonHandler.isOKOne((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.theTwist4");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.theTwist5");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.theBless3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.theBless4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.theBless5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.theBless6");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.theBless1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.theBless2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
        if (stack.m_41793_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.m_20254_(10);
        if (attacker.m_217043_().m_188503_(5) == 0) {
            target.m_147207_(new MobEffectInstance((MobEffect)EnigmaticAddonEffects.ICHOR_CORROSION_EFFECT, 100), (Entity)attacker);
            target.m_5496_(SoundEvents.f_12514_, 0.5f, 0.1f);
        }
        List effects = target.m_21220_().stream().toList();
        for (MobEffectInstance effect : effects) {
            if (!effect.m_19544_().m_19486_()) continue;
            target.m_21195_(effect.m_19544_());
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack offhandStack;
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BROKEN_RING)) {
            List entities = world.m_45976_(PermanentItemEntity.class, player.m_20191_().m_82400_(4.0));
            if (entities.isEmpty()) {
                return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
            }
            for (PermanentItemEntity entity : entities) {
                ItemStack stack = entity.getItem();
                if (!(stack.m_41720_() instanceof SoulCrystal) || !player.m_20148_().equals(entity.getOwnerId())) continue;
                if (!player.m_36356_(EnigmaticItems.SOUL_CRYSTAL.m_7968_())) {
                    Block.m_49840_((Level)world, (BlockPos)player.m_20183_(), (ItemStack)EnigmaticItems.SOUL_CRYSTAL.m_7968_());
                }
                SoulArchive.getInstance().removeItem(entity);
                entity.m_146870_();
                stack.m_41764_(0);
            }
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)world.f_46443_);
        }
        if (!SuperAddonHandler.isOKOne(player)) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        if (hand == InteractionHand.MAIN_HAND && (offhandStack = player.m_21206_()) != null && offhandStack.m_41720_().m_6164_(offhandStack) == UseAnim.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }
}

