/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.api.items.IBlessed;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class ScorchedCharm
extends ItemBaseCurio
implements ICursed,
IBlessed {
    public static Omniconfig.DoubleParameter lavaHealAmount;
    public static Omniconfig.PerhapsParameter lifestealModifier;
    public static Omniconfig.PerhapsParameter resistanceProbability;
    public List<ResourceKey<DamageType>> immunityList = new ArrayList<ResourceKey<DamageType>>();

    public ScorchedCharm() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_());
        this.immunityList.add((ResourceKey<DamageType>)DamageTypes.f_268631_);
        this.immunityList.add((ResourceKey<DamageType>)DamageTypes.f_268468_);
        this.immunityList.add((ResourceKey<DamageType>)DamageTypes.f_268434_);
        this.immunityList.add((ResourceKey<DamageType>)DamageTypes.f_268546_);
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("CharmofScorchedSun");
        lavaHealAmount = builder.comment("The heal amount per second when you're in lava with this Charm.").max(100.0).min(0.0).getDouble("LavaHealAmount", 2.0);
        lifestealModifier = builder.comment("The lifesteal modifier provided by this charm when you attack a target on fire. Measured in percentage.").max(100.0).getPerhaps("LifestealModifier", 20);
        resistanceProbability = builder.comment("The probability to resist damage when you are attacked with this charm. Measured in percentage.").max(100.0).getPerhaps("ResistanceProbability", 10);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.scorchedCharm1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.scorchedCharm2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.scorchedCharm3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.scorchedCharm4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.scorchedCharm5");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity.m_6060_()) {
            entity.m_20095_();
        }
        if (entity.m_20077_()) {
            Player player;
            if (entity.f_19797_ % 20 == 0) {
                entity.m_5634_((float)lavaHealAmount.getValue());
            }
            if (entity instanceof Player && !(player = (Player)entity).m_6129_()) {
                return;
            }
            CollisionContext collisionContext = CollisionContext.m_82750_((Entity)entity);
            if (collisionContext.m_6513_(LiquidBlock.f_54690_, entity.m_20183_(), true) && !entity.m_9236_().m_6425_(entity.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                entity.m_6853_(true);
            } else {
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, entity.m_6047_() ? -0.01 : 0.07, 0.0));
            }
        }
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        if (super.canEquip(context, stack)) {
            Player player;
            LivingEntity entity = context.entity();
            return entity instanceof Player && SuperAddonHandler.isOKOne(player = (Player)entity);
        }
        return false;
    }
}

