/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.BerserkEmblem;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class HellBladeCharm
extends ItemBaseCurio {
    public static Omniconfig.IntParameter equipCooldown;
    public static Omniconfig.DoubleParameter healMultiplier;
    public static Omniconfig.PerhapsParameter damageMultiplier;
    public static Omniconfig.PerhapsParameter armorDebuff;
    public static Omniconfig.PerhapsParameter killThreshold;
    public static Omniconfig.PerhapsParameter killCursedThreshold;

    public HellBladeCharm() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_().m_41495_((Item)EnigmaticAddonItems.HELL_BLADE_CHARM));
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("CharmofHellBlade");
        equipCooldown = builder.comment("The Cooldown to unequip this Charm. Defined as tick.").max(32768.0).getInt("EquipCooldown", 1200);
        damageMultiplier = builder.comment("The damage boost for who bear the charm. Measured as percentage.").max(200.0).min(10.0).getPerhaps("DamageModifier", 100);
        armorDebuff = builder.comment("How much less effective armor will be for those who bear the charm. Measured as percentage.").max(100.0).min(50.0).getPerhaps("ArmorDebuff", 100);
        killThreshold = builder.comment("The kill threshold of Hell Blade Charm to active the skill.").max(100.0).getPerhaps("KillThreshold", 75);
        killCursedThreshold = builder.comment("The kill threshold of Hell Blade Charm to active the skill with Ring of Seven Curses.").max(100.0).getPerhaps("KillCursedThreshold", 50);
        healMultiplier = builder.comment("The Multiplier of healing when active the skill of Hell Blade Charm.").max(100.0).getDouble("HealMultiplier", 0.8);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        boolean flag;
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean bl = flag = player != null && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BERSERK_CHARM);
        if (Screen.m_96638_()) {
            double armorModifier = (double)armorDebuff.getValue().asModifier() * (flag ? 0.6 : 1.0);
            if (armorModifier == 1.0) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.hellBladeCharm1");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.hellBladeCharm1_alt", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("%.0f", armorModifier * 100.0) + "%"});
            }
            if (flag) {
                float boost = SuperpositionHandler.getMissingHealthPool((Player)player) * 25.0f + (float)damageMultiplier.getValue().asPercentage();
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.hellBladeCharm2_alt", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("%.0f", Float.valueOf(boost)) + "%"});
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.hellBladeCharm2");
            }
            if (player != null && SuperpositionHandler.isTheCursedOne((Player)player)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.hellBladeCharm3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{killCursedThreshold + "%"});
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.hellBladeCharm3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{killThreshold + "%"});
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.hellBladeCharm4");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        this.addAttributes(list, stack, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addAttributes(List<Component> list, ItemStack stack, LocalPlayer player) {
        boolean flag = player != null && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BERSERK_CHARM);
        float boost = (float)damageMultiplier.getValue().asPercentage() + (flag ? SuperpositionHandler.getMissingHealthPool((Player)player) * (float)BerserkEmblem.attackDamage.getValue() * 20.0f : 0.0f);
        double armorModifier = (double)armorDebuff.getValue().asModifier() * (flag ? 0.6 : 1.0);
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedFormattedString(list, (String)"curios.modifiers.charm", (ChatFormatting)ChatFormatting.GOLD);
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.damage", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + String.format("%.0f", Float.valueOf(boost)) + "%"});
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.armor", (ChatFormatting)ChatFormatting.RED, (Object[])new Object[]{"-" + String.format("%.0f", armorModifier * 100.0) + "%"});
    }

    public Multimap<Attribute, AttributeModifier> createAttributeMap(Player player) {
        HashMultimap attributes = HashMultimap.create();
        double armorModifier = (double)armorDebuff.getValue().asModifier() * (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BERSERK_CHARM) ? 0.6 : 1.0);
        attributes.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(UUID.fromString("E7EC5AC7-8D8C-9D83-A87C-1830B55951FA"), "Hell Bonus", -armorModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        attributes.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(UUID.fromString("03153759-3B92-E47E-EFED-DD4F2ECA6B47"), "Hell Bonus", -armorModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributes;
    }

    public void onEquip(SlotContext context, ItemStack prevStack, ItemStack stack) {
        Player player;
        super.onEquip(context, prevStack, stack);
        LivingEntity entity = context.entity();
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_()) {
            int multiplier = SuperpositionHandler.isTheCursedOne((Player)player) ? 2 : 1;
            player.m_36335_().m_41524_((Item)this, equipCooldown.getValue() * multiplier);
        }
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_21204_().m_22178_(this.createAttributeMap(player));
        }
    }

    public void onUnequip(SlotContext context, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_21204_().m_22161_(this.createAttributeMap(player));
        }
    }

    public boolean canUnequip(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity entity = context.entity();
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_()) {
            return !player.m_36335_().m_41519_((Item)this);
        }
        return super.canUnequip(context, stack);
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }
}

