/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.contents.objects.etheriumSheild.EtheriumShieldCapability;
import auviotre.enigmatic.addon.contents.objects.etheriumSheild.IEtheriumShieldData;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.config.EtheriumConfigHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.SlotContext;

public class EtheriumCore
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.DoubleParameter armorBonus;
    public static Omniconfig.PerhapsParameter armorMultiplier;
    public static Omniconfig.DoubleParameter armorToughnessBonus;
    public static Omniconfig.PerhapsParameter armorToughnessMultiplier;
    public static Omniconfig.PerhapsParameter knockbackResistance;
    public static Omniconfig.PerhapsParameter damageConversion;
    public static Omniconfig.DoubleParameter damageConversionMax;

    public EtheriumCore() {
        super(ItemSpellstoneCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_());
        this.immunityList.add(DamageTypes.f_268585_);
        this.immunityList.add(DamageTypes.f_268613_);
        this.immunityList.add(DamageTypes.f_268612_);
        this.immunityList.add(DamageTypes.f_268659_);
        this.immunityList.add(DamageTypes.f_268469_);
        this.immunityList.add(DamageTypes.f_268469_);
        this.immunityList.add(DamageTypes.f_268565_);
        this.immunityList.add(DamageTypes.f_268448_);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EtheriumCore");
        spellstoneCooldown = builder.comment("Active ability cooldown for Etherium Core. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 800);
        armorBonus = builder.comment("Default amount of armor points provided by Etherium Core.").max(256.0).getDouble("Armor", 12.0);
        armorMultiplier = builder.comment("The multiplier of armor points of Etherium Core.").max(100.0).getPerhaps("ArmorMultiplier", 20);
        armorToughnessBonus = builder.comment("The amount of armor toughness provided by Etherium Core when it's bearer has no armor equipped.").max(256.0).getDouble("ArmorToughness", 10.0);
        armorToughnessMultiplier = builder.comment("The multiplier of armor toughness of Etherium Core.").max(100.0).getPerhaps("ArmorToughnessMultiplier", 40);
        knockbackResistance = builder.comment("Resistance to knockback provided by Etherium Core. Defined as percentage.").max(100.0).getPerhaps("KnockbackResistance", 50);
        damageConversion = builder.comment("The damage amplification conversion ratio of Etherium Core. Defined as percentage.").max(100.0).getPerhaps("DamageConversion", 40);
        damageConversionMax = builder.comment("The max damage amplification of Etherium Core.").max(100.0).getDouble("DamageConversionMax", 25.0);
        builder.popPrefix();
    }

    public static boolean hasShield(Player player) {
        return player != null && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.ETHERIUM_CORE) && (double)(player.m_21223_() / player.m_21233_()) <= EtheriumConfigHandler.instance().getShieldThreshold(player).asMultiplier() * 1.5;
    }

    public static int getShieldTick(Player player) {
        LazyOptional<IEtheriumShieldData> shieldData = SuperAddonHandler.getCapability(player, EtheriumShieldCapability.ETHERIUM_SHIELD_DATA);
        return shieldData.isPresent() ? ((IEtheriumShieldData)shieldData.orElse(null)).getTick() : -1;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(UUID.fromString("554893CF-3922-46D9-A507-FAD7A7669EC0"), "Etherium Armor", armorBonus.getValue(), AttributeModifier.Operation.ADDITION));
        attributes.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(UUID.fromString("9B64D316-1C37-44F6-9E2F-239C8B1C0030"), "Etherium Knockback Resistance", (double)knockbackResistance.getValue().asModifier(), AttributeModifier.Operation.ADDITION));
        attributes.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(UUID.fromString("DFEE887C-F2C0-491F-BCB6-4148855272CB"), "Etherium Toughness", armorToughnessBonus.getValue(), AttributeModifier.Operation.ADDITION));
        attributes.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(UUID.fromString("B5118D05-AB68-49A1-A622-BFAF8340FAB5"), "Etherium Armor Plus", (double)armorMultiplier.getValue().asModifier(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        attributes.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(UUID.fromString("A0A3F1D2-D324-4099-8B76-9351478CDD26"), "Etherium Toughness Plus", (double)armorToughnessMultiplier.getValue().asModifier(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Float.valueOf((float)spellstoneCooldown.getValue() * 0.03f)});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCoreCooldown", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Float.valueOf((float)spellstoneCooldown.getValue() / 20.0f)});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.golemHeart3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + (int)armorBonus.getValue(), "+" + (int)armorToughnessBonus.getValue()});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + armorMultiplier.getValue() + "%", "+" + armorToughnessMultiplier.getValue() + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.golemHeart9", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{knockbackResistance.getValue().asPercentage() + "%"});
            if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"ArmorInvisibility", (boolean)false)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore5");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore5_alt");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore6", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{damageConversion.getValue().asPercentage() + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore7");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore8");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.etheriumCore9");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.currentKeybind", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{((Component)KeyMapping.m_90842_((String)"key.spellstoneAbility").get()).getString().toUpperCase()});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand handIn) {
        ItemStack stack = player.m_21120_(handIn);
        if (player.m_6047_()) {
            if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"ArmorInvisibility", (boolean)false)) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)"ArmorInvisibility", (boolean)false);
                world.m_5594_(null, player.m_20183_(), EnigmaticSounds.CHARGED_OFF, SoundSource.PLAYERS, (float)(0.8 + Math.random() * 0.2), (float)(0.8 + Math.random() * 0.2));
            } else {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)"ArmorInvisibility", (boolean)true);
                world.m_5594_(null, player.m_20183_(), EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, (float)(0.8 + Math.random() * 0.2), (float)(0.8 + Math.random() * 0.2));
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void triggerActiveAbility(Level world, ServerPlayer player, ItemStack stack) {
        if (!SuperpositionHandler.hasSpellstoneCooldown((Player)player)) {
            SuperpositionHandler.setSpellstoneCooldown((Player)player, (int)spellstoneCooldown.getValue());
            LazyOptional<IEtheriumShieldData> shieldData = SuperAddonHandler.getCapability((Player)player, EtheriumShieldCapability.ETHERIUM_SHIELD_DATA);
            shieldData.ifPresent(cap -> cap.setTick(spellstoneCooldown.getValue() / 2));
        }
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return !context.entity().m_6047_();
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }
}

