/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.XPUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlock;
import com.google.common.math.IntMath;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class XPBlockEntity
extends BlockEntity
implements Nameable {
    private Component name;
    private int storedXP = 0;
    private float storedLevels = 0.0f;

    public XPBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GlobalXP.XP_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public int addXP(int amount) {
        int space = Integer.MAX_VALUE - this.storedXP;
        this.storedXP = IntMath.saturatedAdd((int)this.storedXP, (int)amount);
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        if (amount > space) {
            return amount - space;
        }
        return 0;
    }

    public int removeXP(int amount) {
        int amountRemoved = Math.min(amount, this.storedXP);
        if (amountRemoved <= 0) {
            return 0;
        }
        this.storedXP -= amountRemoved;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        return amountRemoved;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void setStoredXP(int xp) {
        this.storedXP = xp;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public float getStoredLevels() {
        return this.storedLevels;
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("stored_xp", this.storedXP);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setStoredXP(tag.m_128451_("stored_xp"));
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, XPBlockEntity be) {
        if (level.m_46467_() % 5L == 0L && ((Boolean)Configuration.SERVER.pickupXP.get()).booleanValue() && !((Boolean)state.m_61143_((Property)XPBlock.POWERED)).booleanValue()) {
            be.pickupDroppedXP();
        }
    }

    private void pickupDroppedXP() {
        for (ExperienceOrb orb : this.f_58857_.m_6443_(ExperienceOrb.class, this.getPickupArea(), EntitySelector.f_20402_.and(e -> !e.getPersistentData().m_128471_("GlobalXPMarker")))) {
            int amount = orb.m_20801_();
            if (this.getStoredXP() + amount > this.getCapacity()) continue;
            int unused = this.addXP(amount);
            orb.m_146870_();
            if (unused <= 0) continue;
            this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, orb.m_20185_(), orb.m_20186_(), orb.m_20189_(), unused));
        }
    }

    private AABB getPickupArea() {
        double x = (double)this.m_58899_().m_123341_() + 0.5;
        double y = (double)this.m_58899_().m_123342_() + 0.5;
        double z = (double)this.m_58899_().m_123343_() + 0.5;
        double range = (Double)Configuration.SERVER.pickupRange.get() + 0.5;
        return new AABB(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7770_() {
        return this.name;
    }

    public Component getDefaultName() {
        return Component.m_237115_((String)((XPBlock)((Object)GlobalXP.XP_BLOCK.get())).m_7705_());
    }
}

