/*
 * Decompiled with CFR 0.152.
 */
package me.kall.duplicationless.data;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.kall.duplicationless.util.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChunkData<DATA, TYPE>
extends SavedData {
    private final LongSet rebuiltChunks = new LongOpenHashSet();

    @NotNull
    public abstract Object2ObjectMap<ResourceLocation, Long2ObjectMap<Set<DATA>>> data();

    public abstract boolean dataTrustable();

    @Nullable
    public abstract Predicate<TYPE> validation();

    public abstract BiFunction<DATA, ServerLevel, TYPE> dataToType();

    public abstract Function<DATA, Tag> dataToTag();

    public abstract Function<Tag, DATA> tagToData();

    public abstract int dataTagType();

    @NotNull
    private Long2ObjectMap<Set<DATA>> getLevelData(@NotNull ResourceLocation dim) {
        return (Long2ObjectMap)this.data().computeIfAbsent((Object)dim, d -> new Long2ObjectOpenHashMap());
    }

    @NotNull
    private ResourceLocation dim(@NotNull ServerLevel level) {
        return level.m_46472_().m_135782_();
    }

    public void rebuild(ServerLevel level) {
        Predicate<TYPE> validation = this.validation();
        if (this.dataTrustable() || validation == null) {
            return;
        }
        ResourceLocation dim = this.dim(level);
        Long2ObjectMap<Set<DATA>> map = this.getLevelData(dim);
        Long2ObjectArrayMap copy = new Long2ObjectArrayMap(map.size());
        ObjectIterator origin = Long2ObjectMaps.fastIterator(map);
        while (origin.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)origin.next();
            copy.put(entry.getLongKey(), (Object)new ObjectArrayList((Collection)entry.getValue()));
        }
        map.clear();
        BiFunction<DATA, ServerLevel, TYPE> function = this.dataToType();
        ObjectIterator copied = Long2ObjectMaps.fastIterator((Long2ObjectMap)copy);
        while (copied.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)copied.next();
            long chunk = entry.getLongKey();
            List dataList = (List)entry.getValue();
            for (int i = 0; i < dataList.size(); ++i) {
                Object data = dataList.get(i);
                TYPE type = function.apply(data, level);
                if (type == null || !validation.test(type)) continue;
                this.add(level, chunk, data);
            }
        }
    }

    public void rebuildChunk(final ServerLevel level, @NotNull ChunkPos chunkPos) {
        final int chunkX = chunkPos.f_45578_;
        final int chunkZ = chunkPos.f_45579_;
        final long chunk = chunkPos.m_45588_();
        final Predicate<TYPE> validation = this.validation();
        final BiFunction<DATA, ServerLevel, TYPE> function = this.dataToType();
        final ResourceLocation dim = this.dim(level);
        if (this.dataTrustable() || validation == null) {
            return;
        }
        Runnable rebuildTask = new Runnable(){
            private int tries;

            @Override
            public void run() {
                if (this.tries >= 20) {
                    return;
                }
                if (level.m_7232_(chunkX, chunkZ)) {
                    if (!ChunkData.this.rebuiltChunks.contains(chunk)) {
                        ChunkData.this.rebuiltChunks.add(chunk);
                        Long2ObjectMap chunks = ChunkData.this.getLevelData(dim);
                        if (chunks.isEmpty()) {
                            return;
                        }
                        Set dataSet = (Set)chunks.get(chunk);
                        if (dataSet == null || dataSet.isEmpty()) {
                            return;
                        }
                        ObjectArrayList copy = new ObjectArrayList((Collection)dataSet);
                        dataSet.clear();
                        for (Object data : copy) {
                            Object type = function.apply(data, level);
                            if (type == null || !validation.test(type)) continue;
                            ChunkData.this.add(level, chunk, data);
                        }
                    }
                } else {
                    ++this.tries;
                    Executor.runAfter(1, this);
                }
            }
        };
        Executor.run(rebuildTask);
    }

    public void add(ServerLevel level, long chunk, DATA data) {
        if (((Set)this.getLevelData(this.dim(level)).computeIfAbsent(chunk, k -> new ObjectOpenHashSet())).add(data)) {
            this.m_77762_();
        }
    }

    public void remove(ServerLevel level, long chunk, DATA data) {
        Long2ObjectMap<Set<DATA>> map = this.getLevelData(this.dim(level));
        Set s = (Set)map.get(chunk);
        if (s != null && s.remove(data)) {
            if (s.isEmpty()) {
                map.remove(chunk);
            }
            this.m_77762_();
        }
    }

    public boolean has(ServerLevel level, long chunk, DATA data) {
        Set s = (Set)this.getLevelData(this.dim(level)).get(chunk);
        return s != null && s.contains(data);
    }

    @NotNull
    public Set<DATA> viewChunk(ServerLevel level, long chunk) {
        Set s = (Set)this.getLevelData(this.dim(level)).get(chunk);
        return s == null || s.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(s);
    }

    @NotNull
    public Optional<DATA> pick(ServerLevel level, long chunk) {
        Set s = (Set)this.getLevelData(this.dim(level)).get(chunk);
        return s == null || s.isEmpty() || !s.iterator().hasNext() ? Optional.empty() : Optional.of(s.iterator().next());
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        ListTag dimList = new ListTag();
        Function<DATA, Tag> saveFunction = this.dataToTag();
        for (Object2ObjectMap.Entry dimEntry : this.data().object2ObjectEntrySet()) {
            CompoundTag dimTag = new CompoundTag();
            dimTag.m_128359_("id", ((ResourceLocation)dimEntry.getKey()).toString());
            ListTag chunkList = new ListTag();
            for (Long2ObjectMap.Entry entry : ((Long2ObjectMap)dimEntry.getValue()).long2ObjectEntrySet()) {
                CompoundTag chunkTag = new CompoundTag();
                chunkTag.m_128356_("chunk", entry.getLongKey());
                ListTag dataList = new ListTag();
                for (Object data : (Set)entry.getValue()) {
                    dataList.add((Object)saveFunction.apply(data));
                }
                chunkTag.m_128365_("data", (Tag)dataList);
                chunkList.add((Object)chunkTag);
            }
            dimTag.m_128365_("chunks", (Tag)chunkList);
            dimList.add((Object)dimTag);
        }
        tag.m_128365_("dimensions", (Tag)dimList);
        return tag;
    }

    @NotNull
    public ChunkData<DATA, TYPE> load(@NotNull CompoundTag tag) {
        this.data().clear();
        Function<Tag, DATA> loadFunction = this.tagToData();
        ListTag dimList = tag.m_128437_("dimensions", 10);
        for (int d = 0; d < dimList.size(); ++d) {
            CompoundTag dimTag = dimList.m_128728_(d);
            ResourceLocation dim = ResourceLocation.parse((String)dimTag.m_128461_("id"));
            Long2ObjectMap<Set<DATA>> map = this.getLevelData(dim);
            ListTag chunkList = dimTag.m_128437_("chunks", 10);
            for (int i = 0; i < chunkList.size(); ++i) {
                CompoundTag chunkTag = chunkList.m_128728_(i);
                long chunk = chunkTag.m_128454_("chunk");
                ListTag dataList = chunkTag.m_128437_("data", this.dataTagType());
                ObjectOpenHashSet set = new ObjectOpenHashSet();
                for (Tag dataTag : dataList) {
                    set.add(loadFunction.apply(dataTag));
                }
                map.put(chunk, (Object)set);
            }
        }
        this.m_77762_();
        return this;
    }

    @NotNull
    public static <DATA, TYPE> ChunkData<DATA, TYPE> get(@NotNull ServerLevel level, Supplier<ChunkData<DATA, TYPE>> constructor, String name) {
        return (ChunkData)level.m_8895_().m_164861_(tag -> ((ChunkData)((Object)((Object)constructor.get()))).load((CompoundTag)tag), constructor, name);
    }

    public static abstract class BlockData
    extends ChunkData<Long, BlockState> {
        public static final long ZERO = BlockPos.f_121853_.m_121878_();

        @Override
        @NotNull
        public abstract Object2ObjectMap<ResourceLocation, Long2ObjectMap<Set<Long>>> data();

        @Override
        @Nullable
        public abstract Predicate<BlockState> validation();

        @Override
        public BiFunction<Long, ServerLevel, BlockState> dataToType() {
            return (pos, level) -> level.m_8055_(BlockPos.m_122022_((long)pos));
        }

        @Override
        public Function<Long, Tag> dataToTag() {
            return LongTag::m_128882_;
        }

        @Override
        public Function<Tag, Long> tagToData() {
            return tag -> tag instanceof LongTag ? ((LongTag)tag).m_7046_() : ZERO;
        }

        @Override
        public int dataTagType() {
            return 4;
        }
    }

    public static abstract class IdData
    extends ChunkData<Integer, Entity> {
        @Override
        @NotNull
        public abstract Object2ObjectMap<ResourceLocation, Long2ObjectMap<Set<Integer>>> data();

        @Override
        @Nullable
        public abstract Predicate<Entity> validation();

        @Override
        public BiFunction<Integer, ServerLevel, Entity> dataToType() {
            return (id, level) -> level.m_6815_(id.intValue());
        }

        @Override
        public Function<Integer, Tag> dataToTag() {
            return IntTag::m_128679_;
        }

        @Override
        public Function<Tag, Integer> tagToData() {
            return tag -> tag instanceof IntTag ? ((IntTag)tag).m_7047_() : -1;
        }

        @Override
        public int dataTagType() {
            return 3;
        }
    }

    public static abstract class UUIDData
    extends ChunkData<UUID, Entity> {
        @Override
        @NotNull
        public abstract Object2ObjectMap<ResourceLocation, Long2ObjectMap<Set<UUID>>> data();

        @Override
        @Nullable
        public abstract Predicate<Entity> validation();

        @Override
        public BiFunction<UUID, ServerLevel, Entity> dataToType() {
            return (uuid, level) -> level.m_8791_(uuid);
        }

        @Override
        public Function<UUID, Tag> dataToTag() {
            return uuid -> StringTag.m_129297_((String)uuid.toString());
        }

        @Override
        public Function<Tag, UUID> tagToData() {
            return tag -> UUID.fromString(tag.m_7916_());
        }

        @Override
        public int dataTagType() {
            return 8;
        }
    }
}

