/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.gateways_to_emiloot;

import com.saloeater.gateways_to_emiloot.ClickableSlotWidget;
import com.saloeater.gateways_to_emiloot.EmiIntegration;
import com.saloeater.gateways_to_emiloot.GatewayDropRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.client.ClientResourceData;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.stack.BlockStateEmiStack;
import fzzyhmstrs.emi_loot.util.stack.ChestLootEmiStack;
import fzzyhmstrs.emi_loot.util.stack.EntityEmiStack;
import fzzyhmstrs.emi_loot.util.stack.MobLootEmiStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GatewayDropEmiRecipe
implements EmiRecipe {
    int categoryIndex;
    String path;
    int waveIndex;
    ItemStack gatePearl;
    List<EmiStack> itemRewards;
    List<Float> itemRewardChances;
    List<EmiStack> entityRewards;
    List<ChestLootEmiStack> lootTables;
    List<GatewayDropRecipe.EntityWithCount> spawns;
    List<EmiStack> spawnStacks;
    List<EmiStack> outputs;
    Component name;
    int titleHeight = 11;
    int slotSize = 18;
    int itemColumns = 5;
    int slotsStartY = 12;
    int entityColumns = 2;
    int entitiesX = 95;
    int lootTableColumns = 2;
    int spawnColumns = 8;
    int height;

    public GatewayDropEmiRecipe(ItemStack gatePearl, ResourceLocation resourceLocation, GatewayDropRecipe recipe, int categoryIndex) {
        this.categoryIndex = categoryIndex;
        this.path = resourceLocation.m_135815_();
        this.waveIndex = recipe.waveIndex;
        this.gatePearl = gatePearl.m_41777_();
        this.itemRewards = new ArrayList<EmiStack>();
        this.itemRewardChances = new ArrayList<Float>();
        recipe.stacks.forEach(stack -> {
            this.itemRewards.add(EmiStack.of((ItemStack)stack.stack()));
            this.itemRewardChances.add(Float.valueOf(stack.chance()));
        });
        this.outputs = new ArrayList<EmiStack>(this.itemRewards);
        this.name = gatePearl.m_41786_();
        this.entityRewards = new ArrayList<EmiStack>();
        recipe.entityIds.forEach(entityReward -> this.entityRewards.add(this.createEntitySlot(entityReward.type())));
        this.lootTables = new ArrayList<ChestLootEmiStack>();
        recipe.lootTableRewards.forEach(lootTable -> this.lootTables.add(new ChestLootEmiStack(lootTable.lootTableId())));
        this.spawns = recipe.entityWithCounts;
        this.spawnStacks = new ArrayList<EmiStack>();
        this.spawns.forEach(entityWithCount -> {
            this.outputs.add((EmiStack)new MobLootEmiStack(this.toEmiMobLootFormat(ForgeRegistries.ENTITY_TYPES.getKey(entityWithCount.type()))));
            this.spawnStacks.add(this.createEntitySlot(entityWithCount.type()));
        });
        this.height = this.titleHeight + Math.max(this.itemRewards.size() / this.itemColumns, 2 * this.titleHeight + this.lootTables.size() / this.lootTableColumns + this.entityRewards.size() / this.entityColumns) * this.slotSize;
    }

    private ResourceLocation toEmiMobLootFormat(@Nullable ResourceLocation key) {
        if (key == null) {
            return ResourceLocation.fromNamespaceAndPath((String)"gateways_to_emiloot", (String)"entities/unknown");
        }
        return ResourceLocation.fromNamespaceAndPath((String)key.m_135827_(), (String)("entities/" + key.m_135815_()));
    }

    public EmiRecipeCategory getCategory() {
        return EmiIntegration.categories.get(this.categoryIndex);
    }

    @Nullable
    public ResourceLocation getId() {
        return ResourceLocation.m_214293_((String)"gateways_to_emiloot", (String)("/gateway_drop/" + this.path));
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.gatePearl})));
    }

    public List<EmiStack> getOutputs() {
        return Stream.of(this.outputs, this.entityRewards, this.lootTables).flatMap(Collection::stream).toList();
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public void addWidgets(WidgetHolder widgets) {
        int x;
        MutableComponent waveText = this.getWaveText();
        widgets.addText((Component)waveText, this.centeredTextX((Component)waveText), 0, 0x404040, false);
        int y = this.slotsStartY;
        int row = 0;
        int column = 0;
        if (!this.itemRewards.isEmpty()) {
            widgets.addText(this.getDropsText(), 0, this.slotsStartY, 0x404040, false);
            for (EmiStack stack : this.itemRewards) {
                if (column == this.itemColumns) {
                    ++row;
                    column = 0;
                }
                x = column * this.slotSize;
                y = this.slotsStartY + row * this.slotSize + this.titleHeight;
                SlotWidget slot = new SlotWidget((EmiIngredient)stack, x, y);
                widgets.add((Widget)slot.appendTooltip((Component)LText.translatable((String)"emi_loot.percentage", (Object[])new Object[]{FloatTrimmer.trimFloatString((float)this.itemRewardChances.get(column).floatValue())})));
                ++column;
            }
            y += this.slotSize;
        }
        if (!this.entityRewards.isEmpty()) {
            y = this.slotsStartY;
            widgets.addText(this.getFromMobText(), this.entitiesX, this.slotsStartY, 0x404040, false);
            y += this.titleHeight;
            row = 0;
            column = 0;
            for (EmiStack entityRewards : this.entityRewards) {
                if (column == this.entityColumns) {
                    ++row;
                    column = 0;
                    y += this.slotSize;
                }
                x = this.entitiesX + column * this.slotSize;
                widgets.addSlot((EmiIngredient)entityRewards, x, y);
                ++column;
            }
            y += this.slotSize;
        }
        if (!this.lootTables.isEmpty()) {
            widgets.addText(this.getFromLootText(), this.entitiesX, y, 0x404040, false);
            y += this.titleHeight;
            row = 0;
            column = 0;
            for (ChestLootEmiStack lootTable : this.lootTables) {
                if (column == this.lootTableColumns) {
                    ++row;
                    column = 0;
                    y += this.slotSize;
                }
                x = this.entitiesX + column * this.slotSize;
                ItemStack chestSlot = new ItemStack((ItemLike)Items.f_42009_);
                chestSlot.m_41714_(lootTable.getName());
                EmiStack slot = BlockStateEmiStack.of((ItemStack)chestSlot);
                ClickableSlotWidget slotWidget = new ClickableSlotWidget((EmiIngredient)slot, (EmiStack)lootTable, x, y).recipeContext(this);
                widgets.add((Widget)slotWidget);
                ++column;
            }
            y += this.slotSize;
        }
        if (!this.spawns.isEmpty()) {
            y = (int)Math.max((double)y, (double)this.slotsStartY + Math.ceil((double)this.itemRewards.size() / (double)this.itemColumns));
            widgets.addText((Component)Component.m_237115_((String)"gateways_to_emiloot.spawns"), 0, y, 0x404040, false);
            y += this.titleHeight;
            row = 0;
            column = 0;
            int index = 0;
            for (GatewayDropRecipe.EntityWithCount entityWithCount : this.spawns) {
                if (column == this.spawnColumns) {
                    ++row;
                    column = 0;
                    y += this.slotSize;
                }
                int x2 = column * this.slotSize;
                EmiStack entityStack = this.createEntitySlot(entityWithCount.type());
                ClickableSlotWidget slot = new ClickableSlotWidget((EmiIngredient)entityStack, this.spawnStacks.get(index), x2, y).recipeContext(this);
                widgets.add((Widget)slot);
                widgets.addText((Component)Component.m_237113_((String)String.valueOf(entityWithCount.count())), x2 + 1, y + 1, 12397066, false);
                ++column;
                ++index;
            }
        }
    }

    private EmiStack createEntitySlot(EntityType<?> type) {
        EmiStack inputStack;
        Minecraft client = Minecraft.m_91087_();
        Entity entity = type.m_20615_((Level)client.f_91073_);
        if (entity != null) {
            AABB box = entity.m_20191_();
            double len = box.m_82309_();
            if (len > 1.05) {
                len = (len + Math.sqrt(len)) / 2.0;
            }
            if (entity instanceof Slime) {
                ((Slime)entity).m_7839_(5, false);
            }
            double scale = 1.05 / len * 8.0;
            if (ClientResourceData.MOB_SCALES.containsKey(type)) {
                scale *= (double)ClientResourceData.MOB_SCALES.getOrDefault(type, 1.0f);
            }
            inputStack = EntityEmiStack.ofScaled((Entity)entity, (double)scale);
        } else {
            inputStack = EmiStack.EMPTY;
        }
        return inputStack;
    }

    private Component getDropsText() {
        return Component.m_237115_((String)"gateways_to_emiloot.drops");
    }

    private Component getFromMobText() {
        return Component.m_237115_((String)"gateways_to_emiloot.from_mob");
    }

    private Component getFromLootText() {
        return Component.m_237115_((String)"gateways_to_emiloot.from_loot");
    }

    @NotNull
    private MutableComponent getWaveText() {
        if (this.waveIndex == -1) {
            return Component.m_237115_((String)"gateways_to_emiloot.final");
        }
        if (this.waveIndex == -2) {
            return Component.m_237115_((String)"gateways_to_emiloot.wave_endless");
        }
        return Component.m_237110_((String)"gateways_to_emiloot.wave", (Object[])new Object[]{this.waveIndex});
    }

    private int centeredTextX(Component text, int startX, int endX) {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text);
        return startX + (endX - startX - textWidth) / 2;
    }

    private int centeredTextX(Component text) {
        return this.centeredTextX(text, 0, this.getDisplayWidth());
    }

    public boolean supportsRecipeTree() {
        return false;
    }
}

